﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationFriend.h"

#include <nn/util/util_FormatString.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationFriend::NotificationFriend() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetFriendTextColor());
        m_pPanel->SetTextPosition(Style::GetFriendTextPositionX(), Style::GetFriendTextPositionY());
        m_pPanel->SetTextSize(Style::GetFriendTextSize());

        m_OnlineCount  = 0;
        m_RequestCount = 0;
    }

    std::shared_ptr<panel::IPanel> NotificationFriend::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationFriend::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationFriend::SetupFriend(int onlineCount, int requestCount) NN_NOEXCEPT
    {
        m_OnlineCount = onlineCount;
        m_RequestCount = requestCount;

        if(m_OnlineCount == 0 && m_RequestCount == 0)
        {
            return false;
        }

        char str[256] = "";
        int pos = 0;
        int lineCount = 0;
        if(m_OnlineCount > 0)
        {
            if(m_OnlineCount <= 99)
            {
                pos += nn::util::SNPrintf(str + pos, static_cast<size_t>(sizeof(str) - pos), "Friend Online: %d", m_OnlineCount);
            }
            else
            {
                pos += nn::util::SNPrintf(str + pos, static_cast<size_t>(sizeof(str) - pos), "Friend Online: 99+");
            }
            lineCount++;
        }

        if(m_RequestCount > 0)
        {
            if(lineCount > 0)
            {
                pos += nn::util::SNPrintf(str + pos, static_cast<size_t>(sizeof(str) - pos), "\n");
            }
            if(m_OnlineCount <= 300)
            {
                pos += nn::util::SNPrintf(str + pos, static_cast<size_t>(sizeof(str) - pos), "Friend Request: %d", m_RequestCount);
            }
            else
            {
                pos += nn::util::SNPrintf(str + pos, static_cast<size_t>(sizeof(str) - pos), "Friend Request: 300+");
            }
        }

        m_pPanel->SetText(str);
        m_TimeToLive = config::NotificationTtl::GetTtlFriend();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_Friend;
        return true;
    }

}}
