﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationDownload.h"

#include <nn/util/util_FormatString.h>
#include <nn/ovln/format/ovln_DownloadMessage.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationDownload::NotificationDownload() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetDownloadTextColor());
        m_pPanel->SetTextPosition(Style::GetDownloadTextPositionX(), Style::GetDownloadTextPositionY());
        m_pPanel->SetTextSize(Style::GetDownloadTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationDownload::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationDownload::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationDownload::SetupComplete(nn::Bit32 downloadedDataTypes, nn::Bit8 downloadedApplicationAttributes) NN_NOEXCEPT
    {
        char message[256];
        nn::util::SNPrintf(
            message, sizeof(message), "Download complete: %s%s%s%s",
            (downloadedDataTypes & static_cast<nn::Bit32>(nn::ovln::format::DownloadedDataType::Application)) ? "App," : "",
            (downloadedDataTypes & static_cast<nn::Bit32>(nn::ovln::format::DownloadedDataType::Patch)) ?       "Patch," : "",
            (downloadedDataTypes & static_cast<nn::Bit32>(nn::ovln::format::DownloadedDataType::AddOnContent)) ? "AoC," : "",
            (downloadedApplicationAttributes & static_cast<nn::Bit8>(nn::ovln::format::DownloadedApplicationAttributes::Prepurchase)) ? "\nPlease wait for the release." : ""
        );

        m_pPanel->SetText(message);

        m_TimeToLive = config::NotificationTtl::GetTtlDownloadCompleted();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_DownloadCompleted;
        return true;
    }

    NotificationContentAvailable::NotificationContentAvailable() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetDownloadTextColor());
        m_pPanel->SetTextPosition(Style::GetDownloadTextPositionX(), Style::GetDownloadTextPositionY());
        m_pPanel->SetTextSize(Style::GetDownloadTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationContentAvailable::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationContentAvailable::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationContentAvailable::SetupComplete(nn::Bit32 availableDataTypes) NN_NOEXCEPT
    {
        char message[256];
        nn::util::SNPrintf(
            message, sizeof(message), "Content available: %s%s%s",
            (availableDataTypes & static_cast<nn::Bit32>(nn::ovln::format::AvailableDataType::Application)) ? "App," : "",
            (availableDataTypes & static_cast<nn::Bit32>(nn::ovln::format::AvailableDataType::Patch)) ? "Patch," : "",
            (availableDataTypes & static_cast<nn::Bit32>(nn::ovln::format::AvailableDataType::AddOnContent)) ? "AoC," : ""
        );

        m_pPanel->SetText(message);

        m_TimeToLive = config::NotificationTtl::GetTtlDownloadCompleted();
        m_Category = NotificationCategory_Condition;
        m_Priority = config::ConditionPriority_DownloadCompleted;
        return true;
    }
}}
