﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationBatteryCharge.h"

#include <nn/util/util_FormatString.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationBatteryCharge::NotificationBatteryCharge() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetBatteryChargeTextColor());
        m_pPanel->SetTextPosition(Style::GetBatteryChargeTextPositionX(), Style::GetBatteryChargeTextPositionY());
        m_pPanel->SetTextSize(Style::GetBatteryChargeTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationBatteryCharge::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationBatteryCharge::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationBatteryCharge::SetupChargeStart(int batteryPercent) NN_NOEXCEPT
    {
        char str[256] = "";
        nn::util::SNPrintf(str, sizeof(str), "Charging Battery (%d%%)", batteryPercent);
        m_pPanel->SetText(str);

        m_TimeToLive = config::NotificationTtl::GetTtlBatteryChargeStart();
        m_Category   = NotificationCategory_BatteryCharge;
        m_Priority   = 0;
        return true;
    }

    bool NotificationBatteryCharge::SetupChargeError(int batteryPercent) NN_NOEXCEPT
    {
        char str[256] = "";
        nn::util::SNPrintf(str, sizeof(str), "Can't Charge Battery (%d%%)", batteryPercent);
        m_pPanel->SetText(str);

        m_TimeToLive = config::NotificationTtl::GetTtlBatteryChargeStart();
        m_Category   = NotificationCategory_BatteryCharge;
        m_Priority   = 0;
        return true;
    }

    bool NotificationBatteryCharge::SetupChargeStop(int batteryPercent) NN_NOEXCEPT
    {
        char str[256] = "";
        nn::util::SNPrintf(str, sizeof(str), "Battery (%d%%)", batteryPercent);
        m_pPanel->SetText(str);

        m_TimeToLive = config::NotificationTtl::GetTtlBatteryChargeStop();
        m_Category   = NotificationCategory_BatteryCharge;
        m_Priority   = 0;
        return true;
    }

}}
