﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "debug_ActivityCommon.h"

namespace scene{ namespace debug{

    std::pair<int, int> CalculateHidInputViewerSize(int unitSize, int slotCount) NN_NOEXCEPT;

    struct ActivityHidInputViewer
    {
    public:
        enum Scale : int32_t
        {
            Scale_Small  = 2,
            Scale_Medium = 4,
            Scale_Large  = 8,
        };

    public:
        static const bool IsSupported = true;

        int GetWidth() const NN_NOEXCEPT
        {
            return CalculateHidInputViewerSize(this->scale, this->slotCount).first;
        }

        int GetHeight() const NN_NOEXCEPT
        {
            return CalculateHidInputViewerSize(this->scale, this->slotCount).second;
        }

    public:
        NN_DEVOVL_DEBUGMODULEACTIVITY_COMMON("HidInputViewer");

        Scale scale = Scale_Medium;
        int32_t slotCount = 1;
    };

}}
