﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audioctrl.h>
#include <nn/audio.h>
#include "../Common/DevMenu_CommonCheckBox.h"
#include "../Common/DevMenu_CommonDropDown.h"
#include "DevMenu_DeviceSettingsCommon.h"

namespace devmenu { namespace devicesettings {

namespace
{
    const nn::audioctrl::AudioOutputMode TvOutputModeTable[] =
    {
        nn::audioctrl::AudioOutputMode_Pcm1ch,
        nn::audioctrl::AudioOutputMode_Pcm2ch,
        nn::audioctrl::AudioOutputMode_Pcm6ch,
        nn::audioctrl::AudioOutputMode_PcmAuto,
    };

    const nn::audioctrl::AudioOutputMode SystemOutputModeTable[] =
    {
        nn::audioctrl::AudioOutputMode_Pcm1ch,
        nn::audioctrl::AudioOutputMode_Pcm2ch,
    };
}

class TvOutputModeDropDown : public DropDownBase
{
public:
    TvOutputModeDropDown(const glv::Rect& rect, float textSize) NN_NOEXCEPT;

    void UpdateOutputMode() NN_NOEXCEPT;

};

class SystemOutputModeDropDown : public DropDownBase
{
public:
    SystemOutputModeDropDown(const glv::Rect& rect, float textSize) NN_NOEXCEPT;

    void UpdateOutputMode() NN_NOEXCEPT;

};

class TvOutputModeSetting : public glv::Table
{
public:
    explicit TvOutputModeSetting(glv::space_t width) NN_NOEXCEPT;

    void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT;
    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;
    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    glv::View* m_pDropDown;
};

class SystemOutputModeSetting : public glv::Table
{
public:
    explicit SystemOutputModeSetting(glv::space_t width) NN_NOEXCEPT;
    void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT;
    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;
    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    glv::View* m_pDropDown;
};

class ForceMuteOnHeadphoneRemovedSetting : public glv::Table
{
public:
    explicit ForceMuteOnHeadphoneRemovedSetting(glv::space_t width) NN_NOEXCEPT;
    void UpdateSetting() NN_NOEXCEPT;
    void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT;
    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;
    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    devmenu::CheckBoxButton* m_pCheckbox;
};

class HeadphoneOutputLeveLimitSetting : public glv::Table
{
public:
    explicit HeadphoneOutputLeveLimitSetting(glv::space_t width) NN_NOEXCEPT;
    void UpdateSetting() NN_NOEXCEPT;
    void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT;
    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;
    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    devmenu::CheckBoxButton* m_pCheckbox;
};

class PlaybackButtonPanel : public glv::Table
{
public:
    explicit PlaybackButtonPanel(glv::space_t width) NN_NOEXCEPT;
    void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT;
    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;
    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    Button*   m_pPlaybackButton;
    void Playback() NN_NOEXCEPT;
};

class OutputDeviceInformation : public glv::Group
{
public:
    explicit OutputDeviceInformation(glv::space_t w) NN_NOEXCEPT;
    void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT;
    void UpdateInformation(const char* name, int channelCount) NN_NOEXCEPT;
    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;
    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    glv::Label* m_pNameLabel;
    glv::Label* m_pValueLabel;
    glv::Table* m_pTable;
    std::string m_Name;
    Spacer* m_pSpacer;
    int m_ChannelCount;
};

/**************************************
 * class SoundSettings
 **************************************/
class SoundSettings: public SubsectionWithFocusUtility
{
public:
    SoundSettings( Page* pPage, glv::space_t width ) NN_NOEXCEPT;

    virtual void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousFocusItem, glv::View* pNextFocusItem ) const NN_NOEXCEPT final NN_OVERRIDE;
    virtual glv::View* GetFirstFocusTargetView() const NN_NOEXCEPT final NN_OVERRIDE;
    virtual glv::View* GetLastFocusTargetView() const NN_NOEXCEPT final NN_OVERRIDE;

    virtual void OnLoopBeforeSceneRenderer() NN_NOEXCEPT final NN_OVERRIDE;
    virtual void OnLoopAfterSceneRenderer() NN_NOEXCEPT final NN_OVERRIDE;
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

private:
    void UpdateOutputDeviceInformation() NN_NOEXCEPT;

private:
    TvOutputModeSetting*                 m_pTvOutputMode;
    SystemOutputModeSetting*             m_pSystemOutputMode;
    ForceMuteOnHeadphoneRemovedSetting*  m_pForceMuteOnHeadphoneRemoved;
    HeadphoneOutputLeveLimitSetting*     m_pHeadphoneOutputLimit;
    PlaybackButtonPanel*                 m_pPlaybackButtonPanel;
    OutputDeviceInformation*             m_pOutputDeviceInformation;

#if defined( NN_BUILD_CONFIG_SPEC_NX )
    nn::os::SystemEvent m_DeviceNotificationEventForOutput;
#endif // defined( NN_BUILD_CONFIG_SPEC_NX )
};

}} // ~namespace devmenu::devicesettings, ~namespace devmenu
