﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_Common.h"
#include "DevMenu_ModalView.h"
#include "Accounts/DevMenu_AccountsUiComponents.h"

namespace devmenu { namespace shop {

class UserAccountSelector : public ModalView
{
    NN_DISALLOW_COPY( UserAccountSelector );
    NN_DISALLOW_MOVE( UserAccountSelector );

public:
    UserAccountSelector(
        std::function< void( int ) > callback,
        const char* HeaderText = "Select an user account to be related with shop" ) NN_NOEXCEPT;

    virtual ~UserAccountSelector() NN_NOEXCEPT NN_OVERRIDE;

private:
    glv::Placer                     m_Placer;
    glv::Label                      m_Message;
    glv::Label                      m_Invalid;
    devmenu::accounts::UserButton*  m_Buttons[ nn::account::UserCountMax ];
    devmenu::Button                 m_Cancel;
};

}} // ~namespace devmenu::shop, ~namespace devmenu
