﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/os.h>

#include "DevMenu_Notification.h"

namespace devmenu {

/**
 * @brief   通知メッセージレシーバーの登録及び通知実施を行うクラスです。
 */
class NotificationMessageNotifier
{
    NN_DISALLOW_COPY( NotificationMessageNotifier );
    NN_DISALLOW_MOVE( NotificationMessageNotifier );

public:
    NN_IMPLICIT NotificationMessageNotifier() NN_NOEXCEPT;

    ~NotificationMessageNotifier() NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    void Register( NotificationMessageReceiver* pReceiver ) NN_NOEXCEPT;

    void Unregister( NotificationMessageReceiver* pReceiver ) NN_NOEXCEPT;

    void NotifyExecute( NotificationMessageReceiver::Message message ) NN_NOEXCEPT;

private:
    typedef nn::util::IntrusiveList< NotificationMessageReceiver, nn::util::IntrusiveListBaseNodeTraits< NotificationMessageReceiver > > ListImpl;

    nn::os::Mutex   m_ReceiverLock;
    ListImpl        m_ActiveReceivers;
};

} // end of namespace devmenu

