﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenu_CommonSettingsApi.h"

namespace devmenu {

bool IsDebugModeEnabled() NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    return nn::settings::fwdbg::IsDebugModeEnabled();
#else
    // デバッグモードが有効でない実行環境では nn::settings::fwdbg::IsDebugModeEnabled() は常に false を返すが、
    // UI の確認が PC 上でも行えるようにするため true を返すようにする
    return true;
#endif
}

bool GetVariableSizeFirmwareDebugSettingsItemValue( void* outBuf, size_t bufSize, const char* name, const char* key, bool isAbortEnabled ) NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_HORIZON )

    size_t valueSize = nn::settings::fwdbg::GetSettingsItemValueSize( name, key );

    if ( valueSize > bufSize )
    {
        nn::settings::fwdbg::ResetSettingsItemValue( name, key );
        DEVMENU_LOG( "Reset \"%s.%s\" setting\n", name, key );
        valueSize = nn::settings::fwdbg::GetSettingsItemValueSize( name, key );

        if ( valueSize > bufSize )
        {
            if ( isAbortEnabled )
            {
                NN_ABORT( "Failed to get value size of \"%s.%s\" setting\n", name, key );
            }
            else
            {
                NN_SDK_ASSERT( "Failed to get value size of \"%s.%s\" setting\n", name, key );
            }
            return false;
        }
    }

    const size_t readSize = nn::settings::fwdbg::GetSettingsItemValue( outBuf, valueSize, name, key );

    if ( readSize != valueSize )
    {
        if ( isAbortEnabled )
        {
            NN_ABORT( "Failed to read \"%s.%s\" setting\n", name, key );
        }
        else
        {
            NN_SDK_ASSERT( "Failed to read \"%s.%s\" setting\n", name, key );
        }
        return false;
    }

    DEVMENU_LOG_DEBUG( "Succeed to read \"%s.%s\" setting\n", name, key );

#else
    NN_UNUSED( outBuf );
    NN_UNUSED( bufSize );
    NN_UNUSED( name );
    NN_UNUSED( key );
    NN_UNUSED( isAbortEnabled );
#endif
    return true;
}

void SetVariableSizeFirmwareDebugSettingsItemValue( const char* name, const char* key , const void* pValue, size_t valueSize ) NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    nn::settings::fwdbg::SetSettingsItemValue( name, key, pValue, valueSize );
#else
    NN_UNUSED( name );
    NN_UNUSED( key );
    NN_UNUSED( pValue );
    NN_UNUSED( valueSize );
#endif
}

} // ~namespace devmenu
