﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv_notification.h>

#include "../DevMenu_Common.h"
#include "DevMenu_CommonIconLabel.h"

namespace devmenu {

class CheckBoxButton : public glv::View
{
public:
    CheckBoxButton( const char* labelText, glv::space_t horizontalSpaceLength = 10.0f, const char* tableLayout = "< < <",
        bool isLabelAddedFirst = false, const glv::Rect& rect = glv::Rect( 40.0f ) ) NN_NOEXCEPT;
    void SetValue( bool checkboxValue ) NN_NOEXCEPT;
    bool GetValue() NN_NOEXCEPT;
    void SetCallback( glv::Notifier::Callback callback, void* receiver = 0, glv::Update::t type = glv::Update::Clicked ) NN_NOEXCEPT;
    glv::View* GetButtonFocus() NN_NOEXCEPT;
    void SetWidth( glv::space_t width ) NN_NOEXCEPT;
    virtual void onDraw( glv::GLV& glvRoot ) NN_NOEXCEPT NN_OVERRIDE;
private:
    static void UpdateValue( const glv::Notification& n ) NN_NOEXCEPT;

    glv::Button             m_Button;
    glv::Label              m_Label;
    glv::Table              m_Table;
    Spacer                  m_Spacer;
    glv::Notifier::Callback m_UserCallback;
    IconLabel*              m_pCheckMark;
};

} // ~namespace devmenu
