﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../Common/DevMenu_CommonScrollBox.h"
#include "DevMenu_CloudBackupCommons.h"
#include "DevMenu_TransferTaskView.h"


namespace devmenu { namespace cloudbackup {

/**
* Transfer Task Scene
*/
class TransferTaskListScene : public Scene
{
public:
    TransferTaskListScene(ParentPageInterface* pParentPage, const glv::Rect& rect) NN_NOEXCEPT;

    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

    /**
    * 描画前コールバック
    */
    virtual void OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT NN_OVERRIDE;

private:
    ParentPageInterface* m_pParentPage;

    // 戻る
    Button* m_pButtonBack;
};

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
