﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenu_TransferTaskListScene.h"


namespace devmenu { namespace cloudbackup {

/**************************************
class TransferTaskListScene
**************************************/
TransferTaskListScene::TransferTaskListScene(ParentPageInterface* pParentPage, const glv::Rect& rect) NN_NOEXCEPT
    : Scene(rect)
    , m_pParentPage(pParentPage)
    , m_pButtonBack(nullptr)
{
    m_pButtonBack = new Button("< Back",
        [&] {
            m_pParentPage->SwitchScene(SceneType_CloudBackupRoot, true);
        }
        , glv::Rect(DefaultButtonWidth, DefaultButtonHeight));

    // ダミーリスト///////////////////////////////////////////////////////
    ScrollableBoxView* pBox = new ScrollableBoxView("x", glv::Rect(rect.width(), rect.height() - m_pButtonBack->bottom()));
    pBox->pos(0.0f, m_pButtonBack->bottom());
    pBox->enable(glv::Property::KeepWithinParent);
    const int maxTaskCount = 15;
    for (int i = 0; i < maxTaskCount; i++)
    {
        std::string taskName = std::string("Task") + std::to_string(i);

        auto pTaskView = new cloudbackup::TransferTaskView(
            glv::Rect(pBox->width() - 100.0f, 35.0f),
            [&](int id)
            {
                // TODO:モーダルを表示予定
            }
            , TransferTaskInfo
            {
                i, taskName
            }
            );
        *pBox << pTaskView;
    }

    pBox->ArrangeTable();
    *this << pBox;
    // ダミーリスト///////////////////////////////////////////////////////

    *this << m_pButtonBack;

    SetFirstFocusTargetView(m_pButtonBack);
}

void TransferTaskListScene::Refresh() NN_NOEXCEPT
{
    ClearRefreshRequest();
    // TODO:後ほど処理を記載予定
}

/**
* 描画前コールバック
*/
void TransferTaskListScene::OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    if (IsRefreshRequired())
    {
        Refresh();
    }
}

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
