﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include "DevMenu_CloudBackupCommons.h"

namespace devmenu { namespace cloudbackup {

// TODO:引数は仮
typedef std::function< void(const int id) > SelectSaveDataCallback;

/**
* セーブデータ一覧のアイテムビュー
*/
class SaveDataRowView : public glv::Button
{

public:
    // TODO: nn::fs::SaveDataInfoとかdevmenu::SaveDataPropertyとか使う予定。今は仮
    SaveDataRowView(glv::Rect rect, const SelectSaveDataCallback& selectCallback
        , int id// TODO:仮
        , const char* name) NN_NOEXCEPT// TODO:仮
        : glv::Button(rect, true)
        , m_Id(id)
        , m_Label(name, DefaultLabelSpec)
        , m_Callback(selectCallback)
    {
        *this << m_Label;

        changePadClickDetectableButtons(glv::BasicPadEventType::Button::Ok::Mask);
        changePadClickDetectableButtons(glv::DebugPadEventType::Button::Ok::Mask);

        attach([](const glv::Notification& n)->void { n.receiver< SaveDataRowView >()->OnClick(); }, glv::Update::Clicked, this);
    }

private:

    void OnClick() NN_NOEXCEPT
    {
        if (m_Callback != nullptr)
        {
            m_Callback(m_Id);
        }
    }

    const int m_Id;
    glv::Label m_Label;
    const SelectSaveDataCallback& m_Callback;
};

// セーブデータ
class SaveDataList
{

public:
    /**
    * コンストラクタ
    */
    SaveDataList(const SelectSaveDataCallback& callback = SelectSaveDataCallback()) NN_NOEXCEPT
        : m_CallBack(callback)
    {
        // NOOP
    }

    /**
    * デストラクタ
    */
    ~SaveDataList() NN_NOEXCEPT
    {
        // NOOP
    }

    /**
    * 行選択コールバック設定
    */
    void SetCallback(const SelectSaveDataCallback& callback) NN_NOEXCEPT
    {
        m_CallBack = callback;
    }

    /**
    * 更新
    */
    void Refresh(const nn::account::Uid& uid) NN_NOEXCEPT
    {
        Clear();

        // TODO:セーブデータを取得 予定
        // セーブデータリスト

        // ダミーリスト///////////////////////////////////////////////////////
        for (int i = 0; i < 52; i++)
        {
            std::string errorName = std::string("SaveData") + std::to_string(i);

            auto pRowView = new SaveDataRowView(
                glv::Rect(320.f, 80.f),// TODO:要調整
                m_CallBack,
                i, errorName.c_str());

            m_SaveDataRowViewList.push_back(pRowView);
        }
        // ダミーリスト///////////////////////////////////////////////////////
    }

    /**
    * クリア
    */
    void Clear() NN_NOEXCEPT
    {
        for (auto pView : m_SaveDataRowViewList)
        {
            if (pView != nullptr)
            {
                pView->remove();
                delete pView;
                pView = nullptr;
            }
        }
        m_SaveDataRowViewList.clear();
    }

    /**
    * セーブデータリスト取得
    */
    const std::vector<SaveDataRowView*>& GetList() const NN_NOEXCEPT
    {
        return m_SaveDataRowViewList;
    }

private:

    // 行選択コールバック
    SelectSaveDataCallback m_CallBack;

    // セーブデータリスト
    std::vector<SaveDataRowView*> m_SaveDataRowViewList;
};

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
