﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../Common/DevMenu_CommonScrollBox.h"
#include "DevMenu_CloudBackupCommons.h"
#include "DevMenu_ApplicationView.h"
#include "DevMenu_ToggleButton.h"
#include "../Accounts/DevMenu_AccountsUiComponents.h"

namespace devmenu { namespace cloudbackup {


/**
* Account Info Scene
*/
class AccountInfoScene : public Scene
{
public:
    /**
    * コンストラクタ
    */
    AccountInfoScene(ParentPageInterface* pParentPage, const glv::Rect& rect) NN_NOEXCEPT;

    /**
    * クリア
    */
    void Clear() NN_NOEXCEPT;

    /**
    * 更新
    */
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

    /**
    * アカウントUIDの設定
    */
    void SetAccountUid(const nn::account::Uid& uid) NN_NOEXCEPT;

    /**
    * 描画前コールバック
    */
    virtual void OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT NN_OVERRIDE;

    /**
    * シーンに入る際の遷移イベント
    */
    virtual void OnEnterScene() NN_NOEXCEPT NN_OVERRIDE;

    /**
    * アクティブ処理
    */
    virtual void OnActivatePage() NN_NOEXCEPT NN_OVERRIDE;

private:
    /**
    * アカウント情報のヘッダ部。スクロールしない
    */
    class AccountInfoHeader : public glv::Table
    {
    public:
        /**
        * コンストラクタ
        */
        explicit AccountInfoHeader(const glv::Rect& rect) NN_NOEXCEPT;

        /**
        * クリア
        */
        void Clear() NN_NOEXCEPT;

        /**
        * 更新
        */
        void Refresh(const nn::account::Uid& uid) NN_NOEXCEPT;

    private:
        // 幅確保用
        Spacer m_Spacer;

        // ニックネームラベル
        glv::Label* m_pLabelNickname;

        // NSA IDラベル
        glv::Label* m_pLabelNsaId;
    };

    /**
    * アカウント情報の詳細部。スクロールに含まれる
    */
    class AccountInfoDetail : public glv::Table
    {
    public:
        /**
        * コンストラクタ
        */
        explicit AccountInfoDetail(const glv::Rect& rect) NN_NOEXCEPT;

        /**
        * クリア
        */
        void Clear() NN_NOEXCEPT;

        /**
        * 更新
        */
        void Refresh(const nn::account::Uid& uid) NN_NOEXCEPT;

    private:
        // 幅確保用
        Spacer m_Spacer;

        // ユーザーアイコン
        accounts::UserIcon m_UserIcon;

        // 状態ラベル
        glv::Label* m_pLabelStatus;
    };

    /**
    * サーバー処理View
    */
    class ServerControl : public glv::Table, public FocusSettingInterface
    {
    public:
        /**
        * コンストラクタ
        */
        explicit ServerControl(const glv::Rect& rect) NN_NOEXCEPT;

        /**
        * クリア
        */
        void Clear() NN_NOEXCEPT;

        /**
        * 更新
        */
        void Refresh(const nn::account::Uid& uid) NN_NOEXCEPT;

        /**
        * 最初にFocusを当てるViewを取得
        */
        virtual glv::View* GetFirstFocusTargetView() NN_NOEXCEPT NN_OVERRIDE;

        /**
        * 最後にFocusを当てるViewを取得
        */
        virtual glv::View* GetLastFocusTargetView() NN_NOEXCEPT NN_OVERRIDE;

        /**
        * フォーカス設定
        */
        virtual void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT NN_OVERRIDE;

    private:
        // 幅確保用
        Spacer m_Spacer;

        // 自動UL一括 ON/OFF
        CheckBoxButton m_CheckBoxAutoUpload;

        // 自動ULスキャンラベル
        glv::Label m_LabelScanAutoUpload;

        // 自動ULスキャンボタン
        Button m_ButtonScanAutoUpload;

        // サーバー情報キャッシュラベル
        glv::Label m_LabelServerCache;

        // サーバー情報キャッシュの一括更新ボタン
        Button m_ButtonUpdateServerCache;

        // サーバー情報キャッシュの一括削除ボタン
        Button m_ButtonDeleteServerCache;
    };

private:
    /**
    * セーブデータリストの更新
    */
    void RefreshSaveDataList(ScrollableBoxView& scrollBox) NN_NOEXCEPT;

    /**
    * セーブデータリストの除去
    */
    void RemoveSaveDataList() NN_NOEXCEPT;

    /**
    * フォーカス設定
    */
    void RefreshFocusSetting() NN_NOEXCEPT;

private:
    // 親Pageの処理を呼び出すためのInterface
    ParentPageInterface* m_pParentPage;

    // フォーカス管理
    ScrollFocusManager m_FocusManager;

    // 戻る
    Button* m_pButtonBack;

    // UID
    nn::account::Uid m_Uid;

    // アカウント情報ヘッダView
    AccountInfoHeader m_AccountInfoHeader;

    // アカウント詳細情報View
    AccountInfoDetail m_AccountInfoDetail;

    // サーバー処理カテゴリヘッダ
    View* m_pServerControlHeader;

    // サーバー処理View
    ServerControl m_ServerControl;

    // セーブデータカテゴリヘッダ
    View* m_pSaveDataHeader;

    // セーブデータリスト
    SaveDataList m_SaveDataList;

    // セーブデータ無しラベル
    glv::Label m_LabelNoItemForSaveData;

    // 全体のTable
    glv::Table m_LayoutTable;

    // 画面下部のスクロール部
    ScrollableBoxView m_ScrollBox;
};

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
