﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/nn_Common.h>
#include <nn/ns/ns_ApplicationControlDataApi.h>

#include "../DevMenu_Config.h"

namespace devmenu { namespace application {

const char* GetApplicationIdStatementFormat() NN_NOEXCEPT;

void GetHashString( std::string* outDisplayStr, std::string* outQrCodeStr, void* hash, int length ) NN_NOEXCEPT;

const nn::Result GetApplicationControlData( size_t* pOutSize, std::unique_ptr< char[] >* outBuffer, nn::ns::ApplicationControlSource source, const nn::ncm::ApplicationId& id ) NN_NOEXCEPT;

}} // ~namespace devmenu::application, ~namespace devmenu
