﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_AsyncContext.h>
#include <nn/account/account_Types.h>

#include <atomic>
#include <functional>

namespace devmenu {

class Scene;

} // ~namespace devmenu

namespace devmenu { namespace accounts {

class AbstractOperators
{
public:
    virtual void AddUser() const NN_NOEXCEPT = 0;
    virtual void DeleteUser(const nn::account::Uid& user) const NN_NOEXCEPT = 0;
    virtual void OpenUserInfo(const nn::account::Uid& user) const NN_NOEXCEPT = 0;
    virtual void CloseUserInfo() const NN_NOEXCEPT = 0;
    virtual void BeginAsyncTask(nn::account::AsyncContext&& ctx, Scene* prev) const NN_NOEXCEPT = 0;
    virtual void BeginSyncTask(std::function<nn::Result(void)> function, Scene* prev) const NN_NOEXCEPT = 0;
    virtual void OpenFwdbg() const NN_NOEXCEPT = 0;
    virtual void PopScene(glv::View* current, glv::View* next) const NN_NOEXCEPT = 0;
    virtual void RefreshAll() const NN_NOEXCEPT = 0;
    virtual void OpenNicknameSelector(const nn::account::Uid& user) const NN_NOEXCEPT = 0;
    virtual void OpenProfileImageSelector(const nn::account::Uid& user) const NN_NOEXCEPT = 0;
    virtual void OpenBadStatusSelector(const nn::account::Uid& user) const NN_NOEXCEPT = 0;
    virtual void SetFocusableChild(glv::View* pView) const NN_NOEXCEPT = 0;
    virtual void OpenPlayDataInfo(const nn::account::Uid& user) const NN_NOEXCEPT = 0;
    virtual void ClosePlayDataInfo() const NN_NOEXCEPT = 0;
};

class Refreshable
{
private:
    std::atomic<bool> m_RefreshOnNext;
protected:
    Refreshable() NN_NOEXCEPT
        : m_RefreshOnNext(false)
    {
    }
public:
    void RequireRefresh() NN_NOEXCEPT
    {
        m_RefreshOnNext.store(true);
    }
    bool IsRefreshRequired() const NN_NOEXCEPT
    {
        return m_RefreshOnNext.load();
    }
    void ClearRefreshRequest() NN_NOEXCEPT
    {
        m_RefreshOnNext.store(false);
    }
    virtual void Refresh() NN_NOEXCEPT = 0;
};


}} // ~namespace devmenu::accounts, ~namespace devmenu
