﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <functional>

#include <glv_ScissorBoxView.h>
#include <nn/nn_Common.h>

#include "DevMenu_AccountsConfig.h"
#include "DevMenu_AccountsUiComponents.h"
#include "../Common/DevMenu_CommonScene.h"

namespace devmenu { namespace accounts {

class SyncTaskScene
    : public Scene
{
private:
    class Closer
        : public Button
    {
    private:
        const AbstractOperators& m_Op;
        SyncTaskScene& m_Parent;

        void CloseEventCallback() NN_NOEXCEPT;

    public:
        Closer(const AbstractOperators& op, SyncTaskScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
    };

    class Label
        : public glv::View
    {
    private:
        glv::Placer m_Placer;
        glv::Label* m_pTitle;
        glv::Label* m_pDescription;

        enum Mode
        {
            Mode_Progress,
            Mode_Result,
        } m_Mode;
        nn::Result m_Result;

    public:
        Label(SyncTaskScene& parent, const glv::Rect& result) NN_NOEXCEPT;

        void SetProgress() NN_NOEXCEPT;
        void SetResult(nn::Result r) NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;
    };

    static const size_t StackSize = 64 * 1024;

    glv::ScissorBoxView m_Base;
    glv::Placer m_Placer;
    Closer m_Closer;
    Label m_Label;

    std::function<nn::Result(void)> m_pFunction;
    nn::Result m_Result;
    std::atomic<bool> m_IsCompleted;

    nn::os::ThreadType m_Thread;
    void* m_pStack;
    bool m_IsThreadCreated;

    Scene* m_pPreviousScene;

public:
    SyncTaskScene(AbstractOperators& op, glv::Rect rect) NN_NOEXCEPT;
    ~SyncTaskScene() NN_NOEXCEPT;

    glv::View* GetPrimaryView() NN_NOEXCEPT;

    void SetContext(Scene* pPrev, std::function<nn::Result(void)> pFunction) NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

private:
    static void WorkerThread(void* pArg) NN_NOEXCEPT;
};

}} // ~namespace devmenu::accounts, ~namespace devmenu
