﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_AccountsConfig.h"
#include "DevMenu_AccountsUiComponents.h"
#include "DevMenu_AccountsSdkHelper.h"
#include "../Common/DevMenu_CommonScene.h"
#include "../Common/DevMenu_CommonScrollBox.h"

#include <nn/nn_Common.h>

namespace devmenu { namespace accounts {

class AccountView
    : public glv::View
{
private:
    glv::Placer m_Placer; // <- m_pUserContext, m_pUserInfo

    struct UserContext
    {
        bool IsOpen;
        bool IsLastOpened;
    };
    class UserContextView
        : public glv::View
    {
    private:
        static const char LayoutStr[32];
        glv::Table m_Layout;
        glv::Label m_OpenLabel;
        glv::Style m_OpenStyle;
        glv::Label m_LastOpenedLabel;
        glv::Style m_LastOpenedStyle;
        Spacer m_Spacer;

    public:
        UserContextView(const UserContext& context, glv::space_t width, glv::space_t height) NN_NOEXCEPT;
    }* m_pUserContext;

    struct UserInfo
    {
        nn::account::Uid id;

        glv::CharTypeU16 nickname[64];
        devmenu::Buffer icon;

        NsaId nsaId;
    };
    class UserInfoView
        : public glv::Button
    {
    private:
        static const char LayoutStr[32];
        glv::Table m_Layout;
        UserIcon m_Icon;
        glv::Label* m_pNickname;
        glv::Label* m_pStatus;
        char m_StatusString[128];
        Spacer m_Spacer;
        Spacer m_SpacerX16;

        AccountView& m_Parent;
    public:
        UserInfoView(AccountView& parent, const UserInfo& info, glv::space_t width, glv::space_t height) NN_NOEXCEPT;
        virtual ~UserInfoView() NN_NOEXCEPT;

    }* m_pUserInfo;

    AbstractOperators& m_Op;
    nn::account::Uid m_User;

public:
    AccountView(
        AbstractOperators& op,
        const nn::account::Uid& user,
        const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
    virtual ~AccountView() NN_NOEXCEPT;
};

class ListScene
    : public Scene
{
private:
    static constexpr glv::space_t ButtonHeight = 48.0f;
    static constexpr glv::space_t ButtonHorizontalMargin = 32.0f;

    class FwdbgOpener
        : public Button
    {
    private:
        const AbstractOperators& m_Op;

    public:
        FwdbgOpener(const AbstractOperators& op, ListScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
    };
    class Adder
        : public Button
    {
    private:
        const AbstractOperators& m_Op;

    public:
        Adder(const AbstractOperators& op, ListScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
    };

    AbstractOperators& m_Op;
    Table m_Table;
    glv::Label m_Header;
    glv::Label m_Footer;
    glv::Table m_TopButtons;
    ScrollableBoxView m_ScrollableContainer;

    glv::Label m_LabelNoItem;

    FwdbgOpener m_FwdbgOpener;
    Adder* m_pAdder;
    AccountView* m_pAccounts[8];
    glv::View* m_pPrimaryView;

public:
    ListScene(AbstractOperators& op, glv::Rect rect) NN_NOEXCEPT;
    ~ListScene() NN_NOEXCEPT;

    glv::View* GetPrimaryView() const NN_NOEXCEPT;
    void Clear() NN_NOEXCEPT;
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;
};

}} // ~namespace devmenu::accounts, ~namespace devmenu
