﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <cmath>
#include "BluetoothSettingTool_UIControl.h"
#include "BluetoothSettingTool_Types.h"
#include "BluetoothSettingTool_Pad.h"


namespace BluetoothSettingTool {

/*
  UIControl
*/

UIControl::UIControl()
{
    X = 0;
    Y = 0;
    Width  = 0;
    Height = 0;
    Parent = NULL;
}

UIControl::~UIControl()
{}

void UIControl::Show(Display& display)
{
    if(Parent == NULL)
    {
        //display.Clear();
    }

    ShowImpl(display);

    if(Parent == NULL)
    {
        //display.SwapBuffer();
    }
}

void UIControl::InputPad(Pad&)
{}

/*
  Page
*/

void Page::ShowImpl(Display& display)
{
    list<UIControl*>::iterator p = controls.begin();
    Pad& pad = Pad::GetInstance();

    InputPad(pad);

    while(p!= controls.end())
    {
        (*p)->InputPad(pad);
        p++;
    }

    UpdateElements();

    p = controls.begin();
    while(p!= controls.end())
    {
        (*p)->Show(display);
        p++;
    }
}

void Page::Add(UIControl& ui)
{
    ui.Parent = this;
    controls.push_back(&ui);
}

void Page::Remove(UIControl& ui)
{
    ui.Parent = NULL;
    controls.remove(&ui);
}

void Page::Clear()
{
    list<UIControl*>::iterator p = controls.begin();
    while(p !=  controls.end())
    {
        (*p)->Parent = NULL;
        p++;
    }

    controls.clear();
}

void Page::UpdateElements()
{
}

/*
  Label
*/

void Label::ShowImpl(Display& display)
{
    display.SetFontSize(FontWidth, FontHeight);
    display.SetFixedWidth(FixedWidth);
    display.SetColor(BackgroundColor);
    display.DrawRectangle(GetX(), GetY(), Width, Height);
    display.SetColor(TextColor);

    string t;
    uint32_t displayLength = Width / FixedWidth;

    float x;
    switch(Alignment)
    {
    case TopLeft:
    case MiddleLeft:
    case BottomLeft:
        t = Text.substr(0, displayLength);
        x = GetX();
        break;
    case TopCenter:
    case MiddleCenter:
    case BottomCenter:
        t = Text.substr( Text.size() > displayLength ? (Text.size() / 2 - displayLength / 2) : 0, displayLength);
        x = GetX() + ((Width - (t.size() * FontWidth)) / 2);
        break;
    case TopRight:
    case MiddleRight:
    case BottomRight:
        t = Text.substr( Text.size() > displayLength ? (Text.size() - displayLength) : 0, displayLength);
        x = GetX() + (Width - (t.size() * FontWidth));
        break;
    default:
        break;
    }

    float y;
    switch(Alignment)
    {
    case TopLeft:
    case TopCenter:
    case TopRight:
        y = GetY();
        break;
    case MiddleLeft:
    case MiddleCenter:
    case MiddleRight:
        y = GetY() + ((Height - FontHeight) / 2);
        break;
    case BottomLeft:
    case BottomCenter:
    case BottomRight:
        y = GetY() + (Height - FontHeight);
        break;
    default:
        break;
    }

    display.DrawText(x, y, t);
}

void Label::FitSize()
{
    Width = Text.size() * FontWidth;
    Height = FontHeight;
}

Label::Label()
{
    FontWidth = DEFAULT_FONT_WIDTH;
    FontHeight = DEFAULT_FONT_HEIGHT;
    FixedWidth = DEFAULT_FIXED_WIDTH;
    Width = FontWidth * 100;
    Height = 8;
    BackgroundColor = ToColor(BLACK);
    TextColor = ToColor(WHITE);
    Alignment = TopLeft;
}

}    // namespace BluetoothSettingTool
