﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>
#include "Base/BcatTestApp_ConsoleCore.h"

namespace app
{
    class Menu
    {
        const int   Default_DrawColorSet_MenuFrame = 0xffffff;
        const int   Default_DrawColorSet_MenuBack = 0x006630ff;
        const int   Default_DrawColorSet_ItemCursorBack = 0x488080ff;
        const float Default_DrawFrameWidth = 3.0F;

        typedef void (*DrawCallback)( app::FixedProportionalConsole<char>* console, void* arg );
        typedef void (*DrawCallback16)( app::FixedProportionalConsole<char16_t>* console, void* arg );

        static const int DefaultMenuFontSize = 24;
        static const int DefaultLinesDiff = 4;

        NN_DISALLOW_COPY( Menu );
        NN_DISALLOW_MOVE( Menu );

    public:
        Menu() NN_NOEXCEPT :
            m_pConsole( nullptr ),
            m_pConsole16( nullptr ),
            m_ColorBack( Default_DrawColorSet_MenuBack ),
            m_ColorFrame( Default_DrawColorSet_MenuFrame ),
            m_ColorSelect( Default_DrawColorSet_ItemCursorBack ),
            m_FrameWidth( Default_DrawFrameWidth ),
            m_IsUpdated( false ),
            m_IsDrawInactive( true )
        {}
        ~Menu()  NN_NOEXCEPT {}

        //void GetPosition( int* pX, int* pY ) NN_NOEXCEPT;

        static void DrawMenuConsole( void* ) NN_NOEXCEPT;
        app::RectanglePosition& GetPosition(){ return m_Position; }
        int GetFontSize(){ return m_FontSize; }
        int GetLinesDiff(){ return m_LinesDiff; }
        int GetMenuPositionX(){ return m_MenuPositionX; }
        int GetMenuPositionY(){ return m_MenuPositionY; }

        // コンソール作成・廃棄
        void CreateConsole( app::ConsoleSize consoleSize,
                            app::RectanglePosition pos, int consoleSizeX, int consoleSizeY, int menuPositionX, int menuPositionY, int fontSize, int linesDiff, int priority, int tag ) NN_NOEXCEPT;
        void DestroyConsole() NN_NOEXCEPT;
        app::FixedProportionalConsole<char>* GetConsole() NN_NOEXCEPT;
        app::FixedProportionalConsole<char16_t>* GetConsole16() NN_NOEXCEPT;

        // コンソールクリア
        void ClearConsole() NN_NOEXCEPT;

        // 描画コールバック設定(app::Menu::DrawCallback であることに注意)
        void SetCallback( DrawCallback callback, void* arg ) NN_NOEXCEPT;
        void SetCallback16( DrawCallback16 callback, void* arg ) NN_NOEXCEPT;
        // コンソールカラーなどの指定
        void SetBackColor( int colorBack, int colorFrame, float frameWidth = 1.0f ) NN_NOEXCEPT;
        void SetSelectColor( int colorSelect ) NN_NOEXCEPT;
        // アイテムパラメータ設定
        void SetItemParameter( int itemNum, int firstPos ) NN_NOEXCEPT;

        // hid イベント設定
        void SetHidEvent( const glv::HidEvents* pEvent ) NN_NOEXCEPT;

        // カーソル位置
        void SetCursor( int n ) NN_NOEXCEPT;
        int GetCursor() NN_NOEXCEPT;

        // カーソルのコンソールプリント・消去
        void DrawCursor() NN_NOEXCEPT;
        void ClearCursor() NN_NOEXCEPT;

        // 更新(カーソル移動など)
        void Update() NN_NOEXCEPT;
        bool IsUpdated() NN_NOEXCEPT;
        void ClearUpdated() NN_NOEXCEPT;

        // ボタンチェック
        int CheckButtonOk() NN_NOEXCEPT;
        bool CheckButtonCancel() NN_NOEXCEPT;

        // 非アクティブの描画
        void SetDrawInactive( bool sw ) NN_NOEXCEPT
        {
            m_IsDrawInactive = sw;
        }
        bool IsDrawInactive() NN_NOEXCEPT
        {
            return m_IsDrawInactive;
        }

    private:
        // メニューの場所
        app::RectanglePosition m_Position;

        // コンソール情報
        app::FixedProportionalConsole<char>* m_pConsole;
        app::FixedProportionalConsole<char16_t>* m_pConsole16;
        char* m_ConsoleBuffer;
        int m_ColorBack;
        int m_ColorFrame;
        int m_ColorSelect;
        int m_FrameWidth;

        // コンソール上の項目位置
        int m_MenuPositionX;
        int m_MenuPositionY;

        // カーソル位置
        int m_MenuCursor;
        // 最大項目数
        int m_MenuItemMax;

        // フォント情報
        int m_FontSize;
        int m_LinesDiff;

        // 描画コールバック
        DrawCallback m_Callback;
        DrawCallback16 m_Callback16;
        void* m_CallbackArg;
        int m_Tag;

        // hid イベント
        const glv::HidEvents* m_pHidEvent;

        // 更新状況
        bool m_IsUpdated;

        // 非アクティブの描画
        bool m_IsDrawInactive;
    };
}
