﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "Base/BcatTestApp_Sequence.h"

namespace app
{

extern ExecCallbackGroup ExecSaveAllFileGroup;

enum SaveAllFileTarget
{
    SaveAllFileTarget_SaveData, // セーブデータ
    SaveAllFileTarget_SdCard,   // SD カード
};

enum SaveAllFileType
{
    SaveAllFileType_Difference, // 差分更新
    SaveAllFileType_AllForciby  // 強制保存
};

// 受け取りパラメータ
struct SaveAllFileParam
{
    SaveAllFileTarget saveTarget; // どこに保存するか
    SaveAllFileType saveType;     // 保存タイプ(セーブデータのときのみ有効)
    char* pDirectoryName;         // 保存ディレクトリ名(SDカードのときのみ有効)
};

}
