﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/bcat_DeliveryCacheDirectory.h>
#include <nn/bcat/bcat_DeliveryCacheFile.h>

namespace app
{
    // 描画コールバック優先度(小さいほど先)
    enum DrawPriority
    {
        DrawPriority_TopMenu = 30,
        DrawPriority_NetworkConnection = 100,
        DrawPriority_StorageMenu = 100,
        DrawPriority_DirectoryMenu = 100,
        DrawPriority_DirectoryActionMenu = 110,
        DrawPriority_FileMenu = 200,
        DrawPriority_FileActionMenu = 210,
        DrawPriority_BinaryDump = 300,
        DrawPriority_InitializeSaveDataMenu = 200,
        DrawPriority_OtherMenu = 200,
        DrawPriority_SaveAllFile = 200,
    };

    enum DrawColorSet
    {
        // タイトルのフレームと背景色
        DrawColorSet_TitleFrame       = app::ColorSet_Yellow,
        DrawColorSet_TitleBack        = 0xa08080ff,

        // トップメニューのフレームと背景色
        DrawColorSet_TopMenuFrame       = app::ColorSet_White,
        DrawColorSet_TopMenuBack        = 0x404080,

        // ディレクトリ一覧のフレームと背景色
        DrawColorSet_DirectoryMenuFrame  = app::ColorSet_White,
        DrawColorSet_DirectoryMenuBack   = 0x004c4cff,

        // ディレクトリ一アクションメニューのフレームと背景色
        DrawColorSet_DirectoryActionMenuFrame  = 0x30ff80ff,
        DrawColorSet_DirectoryActionMenuBack   = 0x04c4cfff,

        // ファイル一覧のフレームと背景色
        DrawColorSet_FileMenuFrame     = app::ColorSet_White,
        DrawColorSet_FileMenuBack      = 0x04c4cff,

        // ファイルアクションメニューのフレームと背景色
        DrawColorSet_FileActionMenuFrame  = 0x30a0ffff,
        DrawColorSet_FileActionMenuBack   = 0x04949fff,

        // 項目選択用カーソル背景色
        DrawColorSet_ItemCursorBack    = 0x488080ff,

        // 進捗バーフレームと背景色
        DrawColorSet_ProgressBarFrame  = 0xb0b0b0ff,
        DrawColorSet_ProgressBar       = 0xe5e54cff,

        // ファイル進捗表示の背景色
        DrawColorSet_FileProgressBack  = 0x0000cc99,

        // バイナリダンプのフレームと背景色
        DrawColorSet_BinaryDumpFrame = app::ColorSet_White,
        DrawColorSet_BinaryDumpBack  = 0x004c4cff,

        // 汎用メニューのフレームと背景色
        DrawColorSet_MenuFrame = app::ColorSet_White,
        DrawColorSet_MenuBack  = 0x006630ff,

        // その他メニューのフレームと背景色
        DrawColorSet_OtherMenuFrame = 0xf8e840ff,
        DrawColorSet_OtherMenuBack  = 0x606040ff,

        // ネットワーク接続切り替えのフレームと背景色
        DrawColorSet_NetworkConnectionFrame = 0x80ffffff,
        DrawColorSet_NetworkConnectionBack  = 0x40a0a0ff,
    };

    const float DrawFrameWidth = 3.0F;

    // 各メニューウィンドウの位置( x1, y1, x2, y2 )
    const RectanglePosition Position_Title = { 340, 120, 940, 190 };
    const RectanglePosition Position_TopMenu = { 150, 230, 1130, 500 };
    const RectanglePosition Position_NetworkConnection = { 350, 280,  930, 450 };
    const RectanglePosition Position_Progress = { 400, 520, 1130, 612 };
    const RectanglePosition Position_StorageMenu = { 150, 230, 1130, 500 };
    const RectanglePosition Position_DirectoryMenu = { 100, 120, 1180, 600 };
    const RectanglePosition Position_DirectoryActionMenu = { 300, 120, 1180, 600 };
    const RectanglePosition Position_DirectoryListScrollBar = { 1165, 230, 1167, 580 };
    const RectanglePosition Position_FileMenu = { 100, 120, 1180, 600 };
    const RectanglePosition Position_FileMenuScrollBar = { 1165, 230, 1167, 580 };
    const RectanglePosition Position_FileActionMenu = { 150, 200, 1130, 510 };
    const RectanglePosition Position_BinaryDump = { 70, 100, 1210, 620 };
    const RectanglePosition Position_BinaryDumpScrollBar = { 1200, 220, 1202, 594 };
    const RectanglePosition Position_InitializeSaveDataMenu = { 150, 200, 1130, 574 };
    const RectanglePosition Position_SaveAllFile = { 70, 100, 1210, 620 };
    const RectanglePosition Position_SaveAllFileScrollBar = { 1200, 110, 1202, 610 };
    const RectanglePosition Position_DialogInputStr = { 310, 160, 970, 530 };
    const RectanglePosition Position_FileList = { 100, 100, 1170, 608 };
    const RectanglePosition Position_FileListScrollBar = { 1160, 200, 1162, 596 };
    const RectanglePosition Position_OtherMenu = { 150, 200, 1130, 500 };

    // マウント時の名前
    static const char MountSaveDataName[] = "save";
    static const char MountSdCardName[] = "sd";
    // パス長最大値
    static const size_t PathLengthMax = sizeof(MountSaveDataName) + sizeof(nn::bcat::DirectoryName) + sizeof(nn::bcat::FileName) + 3; // ':''/''\0' の分

    // タイトル・バージョン
    static const char* TitleString = "BCAT TEST APPLICATION";
    static const int TitleStringFontSize = 24;
    static const char* VersionString = "ver 0.1.0";
    static const int VersionStringFontSize = 16;
}
