﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

namespace app
{
    //----------------------------------------------------------------
    // パッド(デバッグパッドと通常のものと統合)
    //
    class Pad
    {
        NN_DISALLOW_COPY( Pad );
        NN_DISALLOW_MOVE( Pad );

    public:
        Pad() NN_NOEXCEPT {}
        explicit Pad( const glv::HidEvents& events ) NN_NOEXCEPT
        {
            SetEvents( events );
        }
        ~Pad() NN_NOEXCEPT {}

        void SetEvents( const glv::HidEvents& events ) NN_NOEXCEPT;

        // ボタンの押下を判定
        bool IsButtonDown( glv::DebugPadEventType::ButtonSetType b1, glv::BasicPadEventType::ButtonSetType b2 ) NN_NOEXCEPT
        {
            return ( m_Dpad.IsButtonDown( b1 ) || (m_BpadCount > 0 && m_Bpad.IsButtonDown( b2 ) ) );
        }
        // ボタンのリピート押下を判定
        bool IsButtonRepeat( glv::DebugPadEventType::ButtonSetType b1, glv::BasicPadEventType::ButtonSetType b2 ) NN_NOEXCEPT
        {
            return ( m_Dpad.IsButtonRepeat( b1 ) || (m_BpadCount > 0 && m_Bpad.IsButtonRepeat( b2 ) ) );
        }
        // ボタンの離上を判定
        bool IsButtonUp( glv::DebugPadEventType::ButtonSetType b1, glv::BasicPadEventType::ButtonSetType b2 ) NN_NOEXCEPT
        {
            return ( m_Dpad.IsButtonUp( b1 ) || (m_BpadCount > 0 && m_Bpad.IsButtonUp( b2 ) ) );
        }
        // ボタンの押下中を判定
        bool IsButtonPushing( glv::DebugPadEventType::ButtonSetType b1, glv::BasicPadEventType::ButtonSetType b2 ) NN_NOEXCEPT
        {
            return ( m_Dpad.HasAnyButton( b1 ) || (m_BpadCount > 0 && m_Bpad.HasAnyButton( b2 ) ) );
        }

        //----------------------------------------------------------------
        // 各ボタンの押下を判定
        //
        bool IsButtonDownA() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::A::Mask, glv::BasicPadEventType::Button::A::Mask );
        }
        bool IsButtonDownB() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::B::Mask, glv::BasicPadEventType::Button::B::Mask );
        }
        bool IsButtonDownX() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::X::Mask, glv::BasicPadEventType::Button::X::Mask );
        }
        bool IsButtonDownY() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::Y::Mask, glv::BasicPadEventType::Button::Y::Mask );
        }
        bool IsButtonDownL() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::L::Mask, glv::BasicPadEventType::Button::L::Mask );
        }
        bool IsButtonDownR() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::R::Mask, glv::BasicPadEventType::Button::R::Mask );
        }
        bool IsButtonDownZL() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::ZL::Mask, glv::BasicPadEventType::Button::ZL::Mask );
        }
        bool IsButtonDownZR() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::ZR::Mask, glv::BasicPadEventType::Button::ZR::Mask );
        }
        bool IsButtonDownUp() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::Up::Mask, glv::BasicPadEventType::Button::Up::Mask );
        }
        bool IsButtonDownDown() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::Down::Mask, glv::BasicPadEventType::Button::Down::Mask );
        }
        bool IsButtonDownLeft() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::Left::Mask, glv::BasicPadEventType::Button::Left::Mask );
        }
        bool IsButtonDownRight() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::Right::Mask, glv::BasicPadEventType::Button::Right::Mask );
        }
        bool IsButtonDownPlus() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::Start::Mask, glv::BasicPadEventType::Button::Plus::Mask );
        }
        bool IsButtonDownMinus() NN_NOEXCEPT
        {
            return IsButtonDown( glv::DebugPadEventType::Button::Select::Mask, glv::BasicPadEventType::Button::Minus::Mask );
        }

        //----------------------------------------------------------------
        // 各ボタンのリピート押下を判定
        //
        bool IsButtonRepeatA() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::A::Mask, glv::BasicPadEventType::Button::A::Mask );
        }
        bool IsButtonRepeatB() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::B::Mask, glv::BasicPadEventType::Button::B::Mask );
        }
        bool IsButtonRepeatX() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::X::Mask, glv::BasicPadEventType::Button::X::Mask );
        }
        bool IsButtonRepeatY() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::Y::Mask, glv::BasicPadEventType::Button::Y::Mask );
        }
        bool IsButtonRepeatL() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::L::Mask, glv::BasicPadEventType::Button::L::Mask );
        }
        bool IsButtonRepeatR() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::R::Mask, glv::BasicPadEventType::Button::R::Mask );
        }
        bool IsButtonRepeatZL() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::ZL::Mask, glv::BasicPadEventType::Button::ZL::Mask );
        }
        bool IsButtonRepeatZR() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::ZR::Mask, glv::BasicPadEventType::Button::ZR::Mask );
        }
        bool IsButtonRepeatUp() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::Up::Mask, glv::BasicPadEventType::Button::Up::Mask );
        }
        bool IsButtonRepeatDown() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::Down::Mask, glv::BasicPadEventType::Button::Down::Mask );
        }
        bool IsButtonRepeatLeft() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::Left::Mask, glv::BasicPadEventType::Button::Left::Mask );
        }
        bool IsButtonRepeatRight() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::Right::Mask, glv::BasicPadEventType::Button::Right::Mask );
        }
        bool IsButtonRepeatPlus() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::Start::Mask, glv::BasicPadEventType::Button::Plus::Mask );
        }
        bool IsButtonRepeatMinus() NN_NOEXCEPT
        {
            return IsButtonRepeat( glv::DebugPadEventType::Button::Select::Mask, glv::BasicPadEventType::Button::Minus::Mask );
        }

        //----------------------------------------------------------------
        // 各ボタンの離上を判定
        //
        bool IsButtonUpA() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::A::Mask, glv::BasicPadEventType::Button::A::Mask );
        }
        bool IsButtonUpB() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::B::Mask, glv::BasicPadEventType::Button::B::Mask );
        }
        bool IsButtonUpX() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::X::Mask, glv::BasicPadEventType::Button::X::Mask );
        }
        bool IsButtonUpY() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::Y::Mask, glv::BasicPadEventType::Button::Y::Mask );
        }
        bool IsButtonUpL() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::L::Mask, glv::BasicPadEventType::Button::L::Mask );
        }
        bool IsButtonUpR() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::R::Mask, glv::BasicPadEventType::Button::R::Mask );
        }
        bool IsButtonUpZL() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::ZL::Mask, glv::BasicPadEventType::Button::ZL::Mask );
        }
        bool IsButtonUpZR() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::ZR::Mask, glv::BasicPadEventType::Button::ZR::Mask );
        }
        bool IsButtonUpUp() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::Up::Mask, glv::BasicPadEventType::Button::Up::Mask );
        }
        bool IsButtonUpDown() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::Down::Mask, glv::BasicPadEventType::Button::Down::Mask );
        }
        bool IsButtonUpLeft() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::Left::Mask, glv::BasicPadEventType::Button::Left::Mask );
        }
        bool IsButtonUpRight() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::Right::Mask, glv::BasicPadEventType::Button::Right::Mask );
        }
        bool IsButtonUpPlus() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::Start::Mask, glv::BasicPadEventType::Button::Start::Mask );
        }
        bool IsButtonUpMinus() NN_NOEXCEPT
        {
            return IsButtonUp( glv::DebugPadEventType::Button::Select::Mask, glv::BasicPadEventType::Button::Select::Mask );
        }

        //----------------------------------------------------------------
        // 各ボタンの押下中を判定
        //
        bool IsButtonPushingA() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::A::Mask, glv::BasicPadEventType::Button::A::Mask );
        }
        bool IsButtonPushingB() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::B::Mask, glv::BasicPadEventType::Button::B::Mask );
        }
        bool IsButtonPushingX() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::X::Mask, glv::BasicPadEventType::Button::X::Mask );
        }
        bool IsButtonPushingY() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::Y::Mask, glv::BasicPadEventType::Button::Y::Mask );
        }
        bool IsButtonPushingL() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::L::Mask, glv::BasicPadEventType::Button::L::Mask );
        }
        bool IsButtonPushingR() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::R::Mask, glv::BasicPadEventType::Button::R::Mask );
        }
        bool IsButtonPushingZL() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::ZL::Mask, glv::BasicPadEventType::Button::ZL::Mask );
        }
        bool IsButtonPushingZR() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::ZR::Mask, glv::BasicPadEventType::Button::ZR::Mask );
        }
        bool IsButtonPushingUp() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::Up::Mask, glv::BasicPadEventType::Button::Up::Mask );
        }
        bool IsButtonPushingDown() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::Down::Mask, glv::BasicPadEventType::Button::Down::Mask );
        }
        bool IsButtonPushingLeft() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::Left::Mask, glv::BasicPadEventType::Button::Left::Mask );
        }
        bool IsButtonPushingRight() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::Right::Mask, glv::BasicPadEventType::Button::Right::Mask );
        }
        bool IsButtonPushingPlus() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::Start::Mask, glv::BasicPadEventType::Button::Plus::Mask );
        }
        bool IsButtonPushingMinus() NN_NOEXCEPT
        {
            return IsButtonPushing( glv::DebugPadEventType::Button::Select::Mask, glv::BasicPadEventType::Button::Minus::Mask );
        }

        //----------------------------------------------------------------
        // デバッグパッドのボタン状態
        //
        uint32_t GetDebugPadButton() NN_NOEXCEPT
        {
            return (uint32_t)m_Dpad.GetButtons()._storage[0];
        }

        // 通常パッドのボタン状態
        //
        uint32_t GetBasicPadButton() NN_NOEXCEPT
        {
            return (m_BpadCount > 0) ? (uint32_t)m_Bpad.GetButtons()._storage[0]: 0;
        }

        //----------------------------------------------------------------
        // タッチパネル
        //
        enum TouchAction
        {
            TouchAction_None         = glv::detail::TouchEvent::ActionNone,
            TouchAction_Down         = glv::detail::TouchEvent::ActionDown,
            TouchAction_Move         = glv::detail::TouchEvent::ActionMove,
            TouchAction_Up           = glv::detail::TouchEvent::ActionUp,
            TouchAction_MultipleDown = glv::detail::TouchEvent::ActionMultipleDown,
            TouchAction_MultipleUp   = glv::detail::TouchEvent::ActionMultipleUp,
        };

        // タッチ個数
        int GetTouchCount() NN_NOEXCEPT;

        // タッチアクション
        int GetTouchAction() NN_NOEXCEPT;

        // タッチアクションに対する座標
        // n はインデックス
        bool GetPosition( int n, int* pX, int* pY ) NN_NOEXCEPT;

    private:
        glv::DebugPadEventType m_Dpad;
        glv::BasicPadEventType m_Bpad;
        int m_BpadCount;

        glv::TouchEventType m_Touches;
        int m_TouchCount;
    };

    //----------------------------------------------------------------
    // タッチパネル
    //
    class TouchPanel
    {
        NN_DISALLOW_COPY( TouchPanel );
        NN_DISALLOW_MOVE( TouchPanel );

    public:
        TouchPanel() NN_NOEXCEPT {}
        explicit TouchPanel( app::Pad& pad ) NN_NOEXCEPT;
        ~TouchPanel() NN_NOEXCEPT {}

        // 内部情報のクリア
        static void Clear() NN_NOEXCEPT;

        // タッチの押下判定
        bool IsTouchDown() NN_NOEXCEPT;

        // タッチの押下中判定
        bool IsTouchKeepDown() NN_NOEXCEPT;

        // 押下判定時の座標 (ここでは 1点のみ)
        void GetDownPosition( int* pX, int* pY ) NN_NOEXCEPT;

        // タッチの離上判定(どんな場合も)
        bool IsTouchReleased() NN_NOEXCEPT;

        // タッチの離上判定(座標考慮)
        bool IsTouchUp() NN_NOEXCEPT;

        // 離上判定時の座標 (ここでは 1点のみ)
        void GetUpPosition( int* pX, int* pY ) NN_NOEXCEPT;

        // ドラッグ判定
        bool IsDragged() NN_NOEXCEPT;

        // ドラッグ時の移動量 / 現在座標 / 元の座標 / 距離
        void GetDraggedMove( int* pX, int* pY ) NN_NOEXCEPT;
        void GetDraggedPosition( int* pX, int* pY ) NN_NOEXCEPT;
        void GetDraggedOrigin( int* pX, int* pY ) NN_NOEXCEPT;
        void GetDraggedLength( float *pLength ) NN_NOEXCEPT;
    };

} // namespace app
