﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv_resources.h> // Need to include before socket.h and after curl.h to avoid build error.
#include <glv.h>
#include <glv_binding.h>
#include <glv_tabpages.h>

namespace app
{
typedef void (*ExecCallback)( const glv::HidEvents&, void* );
typedef void (*DrawCallback)( void* );

//----------------------------------------------------------------
class WindowContext : public glv::Window, public glv::GLV, public glv::ApplicationLoopCallback
{
    NN_DISALLOW_COPY( WindowContext );
    NN_DISALLOW_MOVE( WindowContext );

public:
    WindowContext() NN_NOEXCEPT
        : m_ExecCallback( nullptr )
    {
    }

    WindowContext(const unsigned width, const unsigned height) NN_NOEXCEPT;

    ~WindowContext() NN_NOEXCEPT
    {
    }


    void SetDrawCallback( DrawCallback p, void* arg = nullptr ) NN_NOEXCEPT
    {
        m_drawGlv.SetCallback( p, arg );
    }

    ExecCallback m_ExecCallback;
    void* m_ExecCallbackArg;
    void SetExecCallback( ExecCallback p, void* arg = nullptr ) NN_NOEXCEPT
    {
        m_ExecCallback = p;
        m_ExecCallbackArg = arg;
    }

    class drawGlv : public GLV
    {
    public:
        drawGlv() NN_NOEXCEPT
            : m_Callback( nullptr )
        {
        }

        void SetCallback( DrawCallback p, void* arg ) NN_NOEXCEPT
        {
            m_Callback = p;
            m_CallbackArg = arg;
        }

        void onDraw( GLV& g ) NN_NOEXCEPT NN_OVERRIDE
        {
            if ( m_Callback )
            {
                (m_Callback)( m_CallbackArg );
            }
        }

    private:
        DrawCallback m_Callback;
        void* m_CallbackArg;
    } m_drawGlv;

    // ランタイムエンジンにアタッチされた際に呼ばれます。
    virtual void OnLoopAttached(glv::ApplicationLoopContext& context) NN_NOEXCEPT NN_OVERRIDE;
    // ランタイムエンジンからデタッチされた際に呼ばれます。
    virtual void OnLoopDetached(glv::ApplicationLoopContext& context) NN_NOEXCEPT NN_OVERRIDE;
    // glv シーンレンダラ前に呼ばれます。
    virtual const glv::RequiredRestoration OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT NN_OVERRIDE;
    // glv シーンレンダラ後に呼ばれます。
    virtual const glv::RequiredRestoration OnLoopAfterSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT NN_OVERRIDE;
    // イベント処理時に呼ばれます。
    //virtual bool onEvent(glv::Event::t events, glv::GLV& context) NN_NOEXCEPT NN_OVERRIDE;

}; //class WindowContext

} // namespace app
