﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <sstream>
#include <cstdlib>
#include <string>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include "BackupSaveData.h"

#if defined(NN_BACKUPSAVEDATA_SYSTEM)
const nn::Bit64 SystemFeatureIdMask = 0xFFFFFFFFFFFFF000ULL;
const nn::Bit64 SystemFeatureIdBase = 0x0100000000001000ULL;

bool IsBackupTitleForSystem(nn::ncm::ApplicationId applicationId)
{
    nn::Bit64 idValue = applicationId.value;
    if((idValue & SystemFeatureIdMask) == SystemFeatureIdBase)
    {
        return true;
    }
    return false;
}
#endif  // defined(NN_BACKUPSAVEDATA_SYSTEM)
