/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

uniform mat4    uProjection;
uniform vec4    uModelView[3];
uniform vec4    uTransform;
uniform vec4    uTexMtx0_xz;
uniform vec4    uTexMtx0_yw;
uniform vec4    uTexMtx1_xz;
uniform vec4    uTexMtx1_yw;
uniform vec4    uTexMtx2_xz;
uniform vec4    uTexMtx2_yw;
uniform vec4    uColor;
uniform mat4    uVertexTexCoord0;
uniform mat4    uVertexTexCoord1;
uniform mat4    uVertexTexCoord2;
uniform ivec3   uGeneratingTexCoord;
uniform int     uFrameSpec;
uniform vec4    uFrameSize;
uniform vec2    uPaneSize;
uniform vec4    uRcpTexSize0;

in vec2  aVertexIndex;

out vec4 vColor;
out vec4 vTexCoord[3];

#ifdef NW_COLOR_EFFECT_ENABLED
out vec4 vPaneCoord;
#else
uniform mat4 uVertexColor;
#endif


#include "lyt_VsCommon.h"

void main(void)
{
    //----------------------------------------
    // POSITION TRANSFORM
    vec4 world = ShapeQuad(aVertexIndex, uTransform);
    vec4 view = Transform34(uModelView, world);
    gl_Position = view * uProjection;

    //----------------------------------------
    // TEXCOORD & COLOR

    vec4 color;
    #if NW_MULTI_TEXTURE_QUANTITY == 0
    ComputeColorAndTexCoord(color);
    #elif NW_MULTI_TEXTURE_QUANTITY == 1
    vec4 texCoord0;
    ComputeColorAndTexCoord(color, uVertexTexCoord0, texCoord0);
    #elif NW_MULTI_TEXTURE_QUANTITY == 2
    vec4 texCoord0;
    vec4 texCoord1;
    ComputeColorAndTexCoord(color, uVertexTexCoord0, texCoord0, uVertexTexCoord1, texCoord1);
    #elif NW_MULTI_TEXTURE_QUANTITY == 3
    vec4 texCoord0;
    vec4 texCoord1;
    vec4 texCoord2;
    ComputeColorAndTexCoord(color, uVertexTexCoord0, texCoord0, uVertexTexCoord1, texCoord1, uVertexTexCoord2, texCoord2);
    #endif

    // TEXCOORD TRANSFORM
    #if 0 < NW_MULTI_TEXTURE_QUANTITY
    if (uGeneratingTexCoord.x != 0)
    {
        texCoord0 = world * uVertexTexCoord0;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord0.xy = DeformTexCoord(texCoord0.xy);
    }
    vTexCoord[0].xz = vec2(dot(texCoord0, uTexMtx0_xz));
    vTexCoord[0].yw = vec2(dot(texCoord0, uTexMtx0_yw));
    vTexCoord[0].t = 1 - vTexCoord[0].t; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    #endif
    #if 1 < NW_MULTI_TEXTURE_QUANTITY
    if (uGeneratingTexCoord.y != 0)
    {
        texCoord1 = world * uVertexTexCoord1;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord1.xy = DeformTexCoord(texCoord1.xy);
    }
    vTexCoord[1].xz = vec2(dot(texCoord1, uTexMtx1_xz));
    vTexCoord[1].yw = vec2(dot(texCoord1, uTexMtx1_yw));
    vTexCoord[1].t = 1 - vTexCoord[1].t; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    #endif
    #if 2 < NW_MULTI_TEXTURE_QUANTITY
    if (uGeneratingTexCoord.z != 0)
    {
        texCoord2 = world * uVertexTexCoord2;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord2.xy = DeformTexCoord(texCoord2.xy);
    }
    vTexCoord[2].xz = vec2(dot(texCoord2, uTexMtx2_xz));
    vTexCoord[2].yw = vec2(dot(texCoord2, uTexMtx2_yw));
    vTexCoord[2].t = 1 - vTexCoord[2].t; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    #endif

    // GLOBAL COLOR
#ifdef NW_VERTEX_COLOR_ENABLED
    vColor = color * uColor;
#endif
}

