﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/manu/server/manu_UsbXferPipe.h>

#include "manu_Command.h"

namespace nn { namespace manu {

class CommandServer
{
public:
    nn::Result Initialize(void* pStack, size_t stackSize) NN_NOEXCEPT;
    void Run() NN_NOEXCEPT;

private:
    const int usbInterfaceNumber = 3;
    static const int bufferSize;
    NN_ALIGNAS(4096) static char receiveBuffer[];

    os::ThreadType serverThread;
    nn::manu::detail::UsbTransferPipe usbTransferPipe;

    static void RunThread(void* arg) NN_NOEXCEPT;
    void MainLoop() NN_NORETURN;
    nn::Result WaitForReceiveCommand(command::CommandHeader& header) NN_NOEXCEPT;
    nn::Result WaitForReceiveBody(void* body, size_t size) NN_NOEXCEPT;
    nn::Result SendResultId(command::ResultId result) NN_NOEXCEPT;
    nn::Result SendResultData(command::ResultData& resultData) NN_NOEXCEPT;
};

}}
