﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

namespace nn { namespace manu { namespace command {

const uint64_t CommandHeaderMagicNumber = 0x0CAFEFACEDDEAD0F;

enum class CommandId : uint32_t
{
    Nop = 0,
    LaunchApplication = 1,
    Shutdown = 2,
    Reboot = 3,
};

enum class ResultId : uint32_t
{
    Success                 = 0,
    Terminated              = 1,
    DataError               = 2,
    ProcessCommandError     = 3,
    Undefined               = 0xFFFFFFFF,
};

struct ResultData
{
    ResultId    Id;
    uint32_t    Reserved1;
    uint32_t    NnResult;
    uint32_t    Reserved2;
};

struct CommandHeader
{
    uint64_t    MagicNumber;
    CommandId   Command;
    uint32_t    Reserved;
    uint64_t    BodySize;
};

nn::Result ProcessCommand(const CommandHeader& header, const void* body) NN_NOEXCEPT;

}}}
