﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_FirmwareVersion.h>

#include "../../../../Eris/Sources/Processes/scs/scs_CommandProcessor.h"

namespace nn { namespace cs {
    using CommandHeader = nn::scs::CommandHeader;
    using ResponseHeader = nn::scs::ResponseHeader;

    class CommandProcessor : public nn::scs::CommandProcessor
    {
    public:
        virtual bool ProcessCommand(const CommandHeader& header, const Bit8* pBody, int socket);

    protected:
        struct ResponseFirmwareVersion
        {
            ResponseHeader               header;
            nn::settings::system::FirmwareVersion firmwareVersion;
        };
        struct CommandControlVirtualTemperature
        {
            bool            isEnable;
            uint8_t         reserved[3];
            int32_t         temperature;
        };

    private:
        static void SendFirmwareVersion(int socket, const CommandHeader& command);
        static void SendTitleName(const CommandHeader& header, const void* pBody, int socket);

        void ProcessCommandControlVirtualTemperature(
            const CommandHeader& header,
            const void* pBody,
            int socket );
        void ProcessCommandTakeScreenShot(
            const CommandHeader& header,
            int socket);
    };

}}  // namespace nn::cs
