﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//-----------------------------------------------------------------------------
// Font
//-----------------------------------------------------------------------------

const float NormalFontSize = 20.f;
const float NoticeFontSize = 50.f;

//-----------------------------------------------------------------------------
// RootView
//-----------------------------------------------------------------------------

const float RootGap       = 10.f;  // y gap between ContentView and FooterView
const float RootPaddingX  = 5.f;   // x padding to the screen edge
const float RootPaddingY  = 5.f;   // y padding to the screen edge

//-----------------------------------------------------------------------------
// Menu
//-----------------------------------------------------------------------------

const float MenuWidth        = 300.f;
const float MenuEntryHeight  = 50.f;
const float MenuFontSize     = 25.f;
const float MenuActiveBack   = 0.5f;
const float MenuActiveText   = 0.1f;
const float MenuInactiveBack = 0.1f;
const float MenuInactiveText = 0.9f;

//-----------------------------------------------------------------------------
// Footer
//-----------------------------------------------------------------------------

const float FooterPaddingX = 20.f;
const float FooterPaddingY = 15.f;
const float FooterHeight   = 60.f;

//-----------------------------------------------------------------------------
// Content
//-----------------------------------------------------------------------------

const float ContentGap = 10.f; // x gap between DeviceListView and DetailView

//-----------------------------------------------------------------------------
// EpView
//-----------------------------------------------------------------------------

const float EpPaddingX = 5.f;
const float EpPaddingY = 5.f;

//-----------------------------------------------------------------------------
// IfView
//-----------------------------------------------------------------------------

const float IfPaddingX = 5.f;
const float IfPaddingY = 5.f;

//-----------------------------------------------------------------------------
// DeviceView
//-----------------------------------------------------------------------------

const float DevicePaddingX = 5.f;
const float DevicePaddingY = 5.f;

//-----------------------------------------------------------------------------
// DeviceListView
//-----------------------------------------------------------------------------

const float DeviceListGapX = 5.f;  // x gap between DeviceView and scroll bar
const float DeviceListGapY = 10.f; // y gap between DeviceViews
const float DeviceListScrollBarWidth = 15.f;

//-----------------------------------------------------------------------------
// DetailView
//-----------------------------------------------------------------------------

const float DetailPaddingX       = 5.f;
const float DetailPaddingY       = 5.f;
const float DetailScrollBarWidth = 15.f;

//-----------------------------------------------------------------------------
// Geometry
//-----------------------------------------------------------------------------

const float EpWidth           = 250.f;
const float IfWidth           = 300.f + EpWidth;
const float DeviceWidth       = 400.f + IfWidth;

const float DeviceListWidth   = DeviceWidth + DeviceListGapX + DeviceListScrollBarWidth;

const float AnimationSpeed    = 800.f;
