﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_ShareShowArgPrivate.h>

#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonReturnData.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_ShareApiDetail.h>

namespace nn { namespace web {

// enum値一致のチェック
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_EndButtonPressed) == static_cast<int>(web::common::ExitReason::EndButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_BackButtonPressed) == static_cast<int>(web::common::ExitReason::BackButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_ExitMessage) == static_cast<int>(web::common::ExitReason::ExitMessage));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_CallbackUrlReached) == static_cast<int>(web::common::ExitReason::CallbackUrlReached));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_LastWindowDeleted) == static_cast<int>(web::common::ExitReason::LastWindowDeleted));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_LocalNetworkDisconnectionDenied) == static_cast<int>(web::common::ExitReason::LocalNetworkDisconnectionDenied));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_MediaPlayerClosed) == static_cast<int>(web::common::ExitReason::MediaPlayerClosed));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_CausedByWebPage) == static_cast<int>(web::common::ExitReason::CausedByWebPage));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_UserSelectionCanceled) == static_cast<int>(web::common::ExitReason::UserSelectionCanceled));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_NetworkConnectionFailed) == static_cast<int>(web::common::ExitReason::NetworkConnectionFailed));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_SystemUpdateRequired) == static_cast<int>(web::common::ExitReason::SystemUpdateRequired));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_Unexpected) == static_cast<int>(web::common::ExitReason::Unexpected));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_SnsPostRestrictedByParentalControl) == static_cast<int>(web::common::ExitReason::SnsPostRestrictedByParentalControl));
NN_STATIC_ASSERT(static_cast<int>(ShareExitReason_PlayingVideoRestrictedByParentalControl) == static_cast<int>(web::common::ExitReason::PlayingVideoRestrictedByParentalControl));

//------------------------------------------------------------------------
ShowSharePageArg::ShowSharePageArg() NN_NOEXCEPT
: m_Data()
{
    common::CommonArgData::InitializeData(m_Data, common::ShimKind::Share);

    // 左スティックモードを空間ナビへ変更する
    // refs; BROWSER1-550
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::LeftStickMode, common::LeftStickMode::SpatialNavi);

    // Uidを無効値にする
    SetUid(nn::account::InvalidUid);

    // ページ情報ダイアログの URL 表記をドメインに
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseDommainForPageInfo, true);

    // コンテンツ欠落を禁止する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsContentsDropDisabled, true);

    // 再起動ダイアログを抑制する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::SuppressRestartDialog, true);

    // 起動画面を呼び出し元画像にする
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootDisplayKind, common::BootDisplayKind::CallerCapture);
}

//-----------------------------------------------------------------------
ShowSharePageArg::ShowSharePageArg(ShareStartPage shareStartPage) NN_NOEXCEPT
: ShowSharePageArg()
{
    // スタートページ設定
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::ShareStartPage, shareStartPage);
}

//------------------------------------------------------------------------
void ShowSharePageArg::SetAlbumEntry(const nn::capsrv::AlbumEntry& albumEntry) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::AlbumEntry, albumEntry);
}

//------------------------------------------------------------------------
void ShowSharePageArg::AddAlbumEntryAndMediaData(const nn::capsrv::AlbumEntry& albumEntry, const uint8_t* pMediaData, size_t mediaDataLength) NN_NOEXCEPT
{
    const common::CommonArgData::ArgKind albumEntryArgKinds[AlbumEntryMaxCount] = {
        common::CommonArgData::ArgKind::AlbumEntry,
        common::CommonArgData::ArgKind::AlbumEntry2nd,
        common::CommonArgData::ArgKind::AlbumEntry3rd,
        common::CommonArgData::ArgKind::AlbumEntry4th
    };

    const common::CommonArgData::ArgKind additionalMediaDataArgKinds[AlbumEntryMaxCount] = {
        common::CommonArgData::ArgKind::AdditionalMediaData,
        common::CommonArgData::ArgKind::AdditionalMediaData2nd,
        common::CommonArgData::ArgKind::AdditionalMediaData3rd,
        common::CommonArgData::ArgKind::AdditionalMediaData4th
    };

    for (int i = 0; i < AlbumEntryMaxCount; ++i) {
        const common::CommonArgData::ArgKind albumEntryArgKind = albumEntryArgKinds[i];
        const uint8_t* dataPos = common::CommonArgData::GetDataPos(m_Data, albumEntryArgKind);

        if (dataPos == nullptr) {

            common::CommonArgData::SetData(m_Data, albumEntryArgKind, albumEntry);

            if (!(pMediaData == nullptr && mediaDataLength == 0)) {
                NN_SDK_ASSERT(mediaDataLength <= AdditionalMediaDataMaxLength, "MediaDataLength over");
                size_t length = mediaDataLength;
                if (AdditionalMediaDataMaxLength < length) {
                    length = AdditionalMediaDataMaxLength;
                }
                uint8_t data[AdditionalMediaDataMaxLength] = {};
                ::std::memcpy(data, pMediaData, length);
                common::CommonArgData::SetData(m_Data, additionalMediaDataArgKinds[i],
                    AdditionalMediaDataMaxLength, data);
            }

            return;
        }
    }

    NN_SDK_ASSERT(false, "AlbumEntryCount over");
}

//------------------------------------------------------------------------
void ShowSharePageArg::SetApplicationAlbumEntry(const nn::capsrv::ApplicationAlbumEntry& applicationAlbumEntry) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::ApplicationAlbumEntry, applicationAlbumEntry);
}

//------------------------------------------------------------------------
void ShowSharePageArg::SetAdditionalCommentText(const char* pAdditionalCommentText) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::AdditionalCommentText,
        AdditionalCommentTextMaxLength, pAdditionalCommentText);
}

//------------------------------------------------------------------------
void ShowSharePageArg::SetAdditionalMediaData(const uint8_t* pAdditionalMediaData, size_t dataLength) NN_NOEXCEPT
{
    NN_SDK_ASSERT(dataLength <= AdditionalMediaDataMaxLength, "MediaDataLength over");
    size_t length = dataLength;
    if (AdditionalMediaDataMaxLength < length) {
        length = AdditionalMediaDataMaxLength;
    }
    uint8_t data[AdditionalMediaDataMaxLength] = {};
    ::std::memcpy(data, pAdditionalMediaData, length);
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::AdditionalMediaData,
        AdditionalMediaDataMaxLength, data);
}

//------------------------------------------------------------------------
void ShowSharePageArg::SetUid(const nn::account::Uid& uid) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::Uid, uid);
}

//------------------------------------------------------------------------
void ShowSharePageArg::SetMediaCreatorApplicationRatingAge(const int8_t (&ratingAge)[32]) NN_NOEXCEPT
{
    nn::web::common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::MediaCreatorApplicationRatingAge,
        32, ratingAge);
}

//------------------------------------------------------------------------
void ShowSharePageArg::PushToInChannel(nn::applet::LibraryAppletHandle handle) const NN_NOEXCEPT
{
    nn::web::common::CommonApi::PushStorageToInChannel(handle, m_Data, DataSize);
}

//------------------------------------------------------------------------
SharePageReturnValue::SharePageReturnValue() NN_NOEXCEPT
: m_Data()
{
}

//------------------------------------------------------------------------
ShareExitReason SharePageReturnValue::GetShareExitReason() const NN_NOEXCEPT
{
    auto pExitReason = nn::web::common::CommonReturnData::GetExitReason(m_Data);
    if (!pExitReason)
    {
        return ShareExitReason::ShareExitReason_Unexpected;
    }
    return static_cast<ShareExitReason>(*pExitReason);
}

//------------------------------------------------------------------------
const char* SharePageReturnValue::GetLastUrl() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(GetShareExitReason() == ShareExitReason_CallbackUrlReached);
    return reinterpret_cast<const char*>(nn::web::common::CommonReturnData::GetData(
        m_Data, nn::web::common::CommonReturnData::ReturnKind::LastUrl).pBuffer);
}

//------------------------------------------------------------------------
size_t SharePageReturnValue::GetLastUrlSize() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(GetShareExitReason() == ShareExitReason_CallbackUrlReached);
    auto pSize = nn::web::common::CommonReturnData::GetLastUrlSize(m_Data);
    if (!pSize)
    {
        return 0;
    }
    return size_t(*pSize);
}

//------------------------------------------------------------------------
SharePostResult SharePageReturnValue::GetSharePostResult() const NN_NOEXCEPT
{
    auto pResult = nn::web::common::CommonReturnData::GetPostResult(m_Data);
    if (!pResult)
    {
        return SharePostResult::SharePostResult_Cancel;
    }
    return static_cast<SharePostResult>(*pResult);
}

//------------------------------------------------------------------------
const char* SharePageReturnValue::GetPostServiceName() const NN_NOEXCEPT
{
    return reinterpret_cast<const char*>(nn::web::common::CommonReturnData::GetData(
        m_Data, nn::web::common::CommonReturnData::ReturnKind::PostServiceName).pBuffer);
}

//------------------------------------------------------------------------
size_t SharePageReturnValue::GetPostServiceNameSize() const NN_NOEXCEPT
{
    auto pSize = nn::web::common::CommonReturnData::GetPostServiceNameSize(m_Data);
    if (!pSize)
    {
        return 0;
    }
    return size_t(*pSize);
}

//------------------------------------------------------------------------
const char* SharePageReturnValue::GetPostId() const NN_NOEXCEPT
{
    return reinterpret_cast<const char*>(nn::web::common::CommonReturnData::GetData(
        m_Data, nn::web::common::CommonReturnData::ReturnKind::PostId).pBuffer);
}

//------------------------------------------------------------------------
size_t SharePageReturnValue::GetPostIdSize() const NN_NOEXCEPT
{
    auto pSize = nn::web::common::CommonReturnData::GetPostIdSize(m_Data);
    if (!pSize)
    {
        return 0;
    }
    return size_t(*pSize);
}

}} // namespace nn::web
