﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_OfflineShowArgPrivate.h>

#include <string>

#include <nn/applet/applet_Types.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_OfflineApiDetail.h>
#include <nn/web/detail/web_OfflineTypesDetail.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
ShowApplicationLegalInformationPageArg::ShowApplicationLegalInformationPageArg() NN_NOEXCEPT
: m_Data()
{
    // 初期化
    nn::web::common::CommonArgData::InitializeData(m_Data, nn::web::common::ShimKind::Offline);

    // 左スティックモードを空間ナビへ変更する
    // refs; BROWSER1-550
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::LeftStickMode, common::LeftStickMode::SpatialNavi);

    // ページ情報無効化
    // refs: BROWSER1-556
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UsePageInfo, false);

    // デフォルトのポインター無効
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseStickPointer, false);

    // フッターを利用する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::FooterEnabled, true);

    // ロム側で既にビルドされたものに変更を反映させるために
    // フッターを常に表示するようにする対応は OfflineWeb アプレット内部で行っている
    // refs BROWSER1-1606

    // 通常の背景を使う
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BackgroundKind, common::BackgroundKind::Normal);

    // コンテンツ欠落を禁止する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsContentsDropDisabled, true);
    // 再起動ダイアログを抑制する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::SuppressRestartDialog, true);

    // 起動画面を白背景にする
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootDisplayKind, common::BootDisplayKind::White);

    // ブラックリスト以外のURLは許可する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::DenyOnlyBlacklistedURL, true);

    // private 呼び出しが行われることを設定
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsCalledFromPrivateApi, true);
}

//------------------------------------------------------------------------
ShowApplicationLegalInformationPageArg::ShowApplicationLegalInformationPageArg(
    const nn::ApplicationId& id, const char* pDocumentPath) NN_NOEXCEPT
: ShowApplicationLegalInformationPageArg()
{
    // 「ソフトリーガル情報」用ドキュメントを設定する。
    detail::ShowOfflinePageArgDetail::SetDocumentKind(m_Data, detail::OfflineDocumentKind::ApplicationLegalInformation);

    // ApplicationIdを設定
    detail::ShowOfflinePageArgDetail::SetApplicationId(m_Data, id);

    // DocumentPathを設定
    detail::ShowOfflinePageArgDetail::SetDocumentPath(m_Data, DocumentPathMaxLength, pDocumentPath);
}

//------------------------------------------------------------------------
void ShowApplicationLegalInformationPageArg::PushToInChannel(nn::applet::LibraryAppletHandle handle) const NN_NOEXCEPT
{
    common::CommonApi::PushStorageToInChannel(handle, m_Data, DataSize);
}

//------------------------------------------------------------------------
void ShowApplicationLegalInformationPageArg::SetBootFooterButtonVisible(const OfflineFooterButtonId buttonId, const bool visible) NN_NOEXCEPT
{
    common::CommonApi::SetBootFooterButtonVisible(m_Data, common::FooterButtonId(buttonId), visible);
}

//------------------------------------------------------------------------
ShowSystemDataPageArg::ShowSystemDataPageArg() NN_NOEXCEPT
: m_Data()
{
    // 初期化
    common::CommonArgData::InitializeData(m_Data, common::ShimKind::Offline);

    // 左スティックモードを空間ナビへ変更する
    // refs; BROWSER1-550
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::LeftStickMode, common::LeftStickMode::SpatialNavi);

    // ページ情報無効化
    // refs: BROWSER1-556
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UsePageInfo, false);

    // デフォルトはポインター無効
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseStickPointer, false);

    // フッターを利用する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::FooterEnabled, true);

    // 通常の背景を使う
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BackgroundKind, common::BackgroundKind::Normal);

    // 起動画面を白背景にする
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootDisplayKind, common::BootDisplayKind::White);

    // コンテンツ欠落を禁止する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsContentsDropDisabled, true);

    // 再起動ダイアログを抑制する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::SuppressRestartDialog, true);

    // ブラックリスト以外のURLは許可する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::DenyOnlyBlacklistedURL, true);

    // private 呼び出しが行われることを設定
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsCalledFromPrivateApi, true);
}


//------------------------------------------------------------------------
ShowSystemDataPageArg::ShowSystemDataPageArg(const nn::ncm::SystemDataId& id,
    const char* pDocumentPath) NN_NOEXCEPT
: ShowSystemDataPageArg()
{
    // 「システムデータ」を設定する。
    detail::ShowOfflinePageArgDetail::SetDocumentKind(m_Data, detail::OfflineDocumentKind::SystemData);

    // SystemIdを設定
    detail::ShowOfflinePageArgDetail::SetSystemDataId(m_Data, id);

    // DocumentPathを設定
    detail::ShowOfflinePageArgDetail::SetDocumentPath(m_Data, DocumentPathMaxLength, pDocumentPath);
}

//------------------------------------------------------------------------
void ShowSystemDataPageArg::SetFooterFixedKind(const OfflineFooterFixedKind offlineFooterFixedKind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::FooterFixedKind, common::FooterFixedKind(offlineFooterFixedKind));
}

//------------------------------------------------------------------------
void ShowSystemDataPageArg::PushToInChannel(nn::applet::LibraryAppletHandle handle) const NN_NOEXCEPT
{
    common::CommonApi::PushStorageToInChannel(handle, m_Data, DataSize);
}

//------------------------------------------------------------------------
void ShowSystemDataPageArg::SetBootFooterButtonVisible(const OfflineFooterButtonId buttonId, const bool visible) NN_NOEXCEPT
{
    common::CommonApi::SetBootFooterButtonVisible(m_Data, common::FooterButtonId(buttonId), visible);
}


}} // namespace nn::web
