﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_OfflineApiWithSessionPrivate.h>

#include <mutex>
#include <string>

#include <nn/applet/applet_Types.h>
#include <nn/la/la_CommonArgumentsWriter.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_Mutex.h>
#include <nn/web/web_Result.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_OfflineApiDetail.h>
#include <nn/web/detail/web_SessionApiDetail.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
nn::Result ShowOfflineHtmlPageWithSession(OfflineHtmlPageReturnValue* pOutputOfflineHtmlPageReturnValue,
    const ShowOfflineHtmlPageArg& arg, Session& session) NN_NOEXCEPT
{

    // LibraryAppletHandle 生成
    auto handle = nn::web::common::CommonApi::PrepareLibraryApplet(nn::applet::AppletId_LibraryAppletOfflineWeb);

    // 共通引数をプッシュ
    nn::la::CommonArgumentsWriter writer(nn::web::common::ShimVersion, detail::OfflineShimVersion);
    writer.PushToInChannel(handle);

    // Web ページを開くための起動引数をプッシュ
    {
        auto writer = reinterpret_cast<const detail::ShowOfflineHtmlPageArgWriter*>(&arg);
        writer->PushToInChannel(handle);
    }

    // WebOfflineApplet を起動
    nn::web::common::CommonApi::StartLibraryApplet(handle);

    nn::Result result;

    // Session が有効ならLAの監視をします。
    if (session.IsValid())
    {
        auto sessionImpl = reinterpret_cast<detail::SessionImpl*>(session.Impl());
        sessionImpl->setLibraryAppletHandle(handle);

        // LibraryApplet を終了迄待機し、返り値の取得を行います。
        result = nn::web::common::CommonApi::JoinAndFinishLibraryApplet(pOutputOfflineHtmlPageReturnValue, sizeof(*pOutputOfflineHtmlPageReturnValue), handle);
        sessionImpl->setLibraryAppletHandle(nn::applet::InvalidLibraryAppletHandle);
    }
    else
    {
        result = nn::web::common::CommonApi::JoinAndFinishLibraryApplet(pOutputOfflineHtmlPageReturnValue, sizeof(*pOutputOfflineHtmlPageReturnValue), handle);
    }

    if (result.IsSuccess())
    {
        return nn::ResultSuccess();
    }
    else
    {
        return nn::web::ResultTerminated();
    }

}

//------------------------------------------------------------------------
#if 0 // 送信デバッグ用
bool SendDebug(Session& session)
{
    if (session.IsValid())
    {
        auto sessionImpl = reinterpret_cast<detail::SessionImpl*>(session.Impl());
        nn::web::SessionMessageHeader header;
        header.kind = int(nn::web::detail::SendMessageKind::Debug);
        header.size = sizeof(int);
        const char* body = "body";
        return sessionImpl->trySend(header, body);
    }
    return false;
}
#endif

}} // namespace nn::web
