﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_ApiPrivate.h>

#include <nn/la/la_CommonArgumentsWriter.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_TypesDetail.h>

//------------------------------------------------------------------------
#include <nn/nn_Middleware.h>
#include <nn/nn_Version.h>
// libnn_web_news のミドルウェア情報です。
#define NN_WEB_MIDDLEWARE_SYMBOL(buildOption) "NintendoSDK_Web_News-" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MAJOR) "_" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MINOR) "_" NN_MACRO_STRINGIZE(NN_NX_ADDON_VERSION_MICRO) "-" #buildOption

#if defined(NN_SDK_BUILD_DEBUG)
NN_DEFINE_MIDDLEWARE(g_MiddlewareInfo, "Nintendo", NN_WEB_MIDDLEWARE_SYMBOL(Debug));
#elif defined(NN_SDK_BUILD_DEVELOP)
NN_DEFINE_MIDDLEWARE(g_MiddlewareInfo, "Nintendo", NN_WEB_MIDDLEWARE_SYMBOL(Develop));
#elif defined(NN_SDK_BUILD_RELEASE)
NN_DEFINE_MIDDLEWARE(g_MiddlewareInfo, "Nintendo", NN_WEB_MIDDLEWARE_SYMBOL(Release));
#endif
//------------------------------------------------------------------------

namespace nn { namespace web {

//------------------------------------------------------------------------
nn::Result ShowNewsPage(WebPageReturnValue* pOutputWebPageReturnValue,
    const ShowNewsPageArg& arg) NN_NOEXCEPT
{
    NN_USING_MIDDLEWARE(g_MiddlewareInfo);

    auto handle = nn::web::common::CommonApi::PrepareLibraryApplet(applet::AppletId_LibraryAppletWeb);

    // 共通引数をプッシュ
    nn::la::CommonArgumentsWriter writer(nn::web::common::ShimVersion, detail::WebShimVersion);
    writer.PushToInChannel(handle);

    // ニュースページを開くための起動引数をプッシュ
    arg.PushToInChannel(handle);

    // ニュースページを開く
    return nn::web::common::CommonApi::StartLibraryAppletAndWait(pOutputWebPageReturnValue, sizeof(*pOutputWebPageReturnValue), handle);
}

//------------------------------------------------------------------------
nn::Result GetWebPageReutrnValueFromStorage(WebPageReturnValue* pOutputWebPageReturnValue,
    const nn::applet::StorageHandle& handle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutputWebPageReturnValue);
    nn::web::common::CommonApi::ReadFromStorage(
        pOutputWebPageReturnValue, sizeof(WebPageReturnValue), handle);
    return nn::ResultSuccess();
}

}} // namespace nn::web
