﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/detail/web_OfflineApiDetail.h>

#include <string>

#include <nn/applet/applet_Types.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>

namespace nn { namespace web { namespace detail {

//------------------------------------------------------------------------
void ShowOfflineHtmlPageArgWriter::PushToInChannel(nn::applet::LibraryAppletHandle handle) const NN_NOEXCEPT
{
    nn::web::common::CommonApi::PushStorageToInChannel(handle, m_Data, DataSize);
}

//------------------------------------------------------------------------
void ShowOfflinePageArgDetail::SetApplicationId(uint8_t* pDst, const nn::ApplicationId& id) NN_NOEXCEPT
{
    common::CommonArgData::SetData(pDst, common::CommonArgData::ArgKind::ApplicationId,
        sizeof(nn::ncm::ApplicationId),
        reinterpret_cast<nn::ncm::ApplicationId*>(const_cast<nn::ApplicationId*>(&id)));
}

//------------------------------------------------------------------------
void ShowOfflinePageArgDetail::SetDocumentPath(uint8_t* pDst, size_t fixedSize, const char* pDocumentPath) NN_NOEXCEPT
{
    common::CommonArgData::SetData(pDst, common::CommonArgData::ArgKind::DocumentPath,
        fixedSize, pDocumentPath);
}

//------------------------------------------------------------------------
void ShowOfflinePageArgDetail::SetDocumentKind(uint8_t* pDst, const OfflineDocumentKind& documentKind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(pDst, common::CommonArgData::ArgKind::DocumentKind, documentKind);
}

//------------------------------------------------------------------------
void ShowOfflinePageArgDetail::SetSystemDataId(uint8_t* pDst, const nn::ncm::SystemDataId& id) NN_NOEXCEPT
{
    common::CommonArgData::SetData(pDst, common::CommonArgData::ArgKind::SystemDataId, id);
}

//------------------------------------------------------------------------
void ShowOfflinePageArgDetail::SetPointerEnabled(uint8_t* pDst, const bool pointerEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(pDst, common::CommonArgData::ArgKind::UseStickPointer, pointerEnabled);
}

//------------------------------------------------------------------------
void ShowOfflinePageArgDetail::SetLeftStickMode(uint8_t* pDst,
    const OfflineLeftStickMode& mode) NN_NOEXCEPT
{
    common::CommonArgData::SetData(pDst, common::CommonArgData::ArgKind::LeftStickMode, common::LeftStickMode(mode));
}

}}} // namespace nn::web::detail
