﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/applet/applet_ApplicationSelf.h>
#include <nn/applet/applet_ApplicationControlForQuest.h>
#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/nifm/nifm_ApiForTest.h>
#include <nn/ns/ns_ApplicationRecordApi.h>
#include <nn/ns/ns_ApplicationViewApi.h>
#include <nn/rid/rid_LaunchApplicationApi.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace rid {
    namespace{
        void SubmitExclusiveNetworkRequest() NN_NOEXCEPT
        {
            nifm::ClientId clientId = nifm::GetClientId();
            NN_ABORT_UNLESS_RESULT_SUCCESS(nifm::SetExclusiveClient(clientId));
        }
    }

    void RequestToLaunchApplication(ncm::ApplicationId applicationId, bool restrictsNetwork) NN_NOEXCEPT
    {
        if (restrictsNetwork)
        {
            // 独占ネットワーク利用要求を出して体験版アプリのネットワーク利用を制限する
            SubmitExclusiveNetworkRequest();
        }

        applet::StorageHandle handle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(applet::CreateStorage(&handle, 0));
        applet::RequestToLaunchApplication(applicationId, handle);
    }

    void RequestToLaunchApplication(ncm::ApplicationId applicationId, const applet::ApplicationAttributeForQuest* pAttribute, bool restrictsNetwork) NN_NOEXCEPT
    {
        if (restrictsNetwork)
        {
            // 独占ネットワーク利用要求を出して体験版アプリのネットワーク利用を制限する
            SubmitExclusiveNetworkRequest();
        }

        // 起動パラメータはなし
        applet::RequestToLaunchApplicationForQuest(applicationId, applet::InvalidStorageHandle, pAttribute);
    }

    bool RequestToLaunchGameCardApplication() NN_NOEXCEPT
    {
        const int MaxListApplicationCount = 32;
        ns::ApplicationRecord recordList[MaxListApplicationCount];
        int applicationCount;
        int offset = 0;

        while (NN_STATIC_CONDITION(true))
        {
            applicationCount = ns::ListApplicationRecord(recordList, MaxListApplicationCount, offset);
            if (applicationCount <= 0)
            {
                break;
            }

            for (int i = 0; i < applicationCount; i++)
            {
                ns::ApplicationView view;
                NN_ABORT_UNLESS_RESULT_SUCCESS(ns::GetApplicationView(&view, &recordList[i].id, 1));

                if (view.IsGameCard() && view.IsLaunchable())
                {
                    applet::StorageHandle handle;
                    NN_ABORT_UNLESS_RESULT_SUCCESS(applet::CreateStorage(&handle, 0));
                    applet::RequestToLaunchApplication(view.id, handle);

                    return true;
                }
            }

            offset += applicationCount;
        }

        return false;
    }
}}
