﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include "rid_NetworkConnection.h"

namespace nn { namespace rid {

    NetworkConnection::NetworkConnection() NN_NOEXCEPT
    {
        nifm::CancelNetworkRequest();

        NN_ABORT_UNLESS_RESULT_SUCCESS(nifm::SetRequestRequirementPreset(m_Connection.GetRequestHandle(), nifm::RequirementPreset_InternetGeneric));
        m_Connection.SubmitRequestAndWait();
    }

    NetworkConnection::~NetworkConnection() NN_NOEXCEPT
    {
        nifm::SubmitNetworkRequestAndWait();
    }

    void NetworkConnection::SubmitRequestAndWait() NN_NOEXCEPT
    {
        m_Connection.SubmitRequestAndWait();
    }

    bool NetworkConnection::IsAvailable() NN_NOEXCEPT
    {
        return m_Connection.IsAvailable();
    }
}}
