﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/result/result_HandlingUtility.h>

#include "detail/repair_MessageReporter.h"

//!< 失敗時に詳細を表示して Result を返します。
#define NN_REPAIR_RESULT_DO(expression) \
    do \
    { \
        auto _nn_repair_result = (expression); \
        if ( _nn_repair_result.IsFailure() ) \
        { \
            SendMessage( \
                    "Failed: %s\n  Module: %d\n  Description: %d\n  InnerValue: 0x%08x\n", \
                NN_MACRO_STRINGIZE(expression), \
                _nn_repair_result.GetModule(), \
                _nn_repair_result.GetDescription(), \
                _nn_repair_result.GetInnerValueForDebug()); \
            NN_RESULT_DO(_nn_repair_result);\
        } \
    } while ( NN_STATIC_CONDITION(false) )

#define NN_REPAIR_ABORT_UNLESS(expression) \
    do \
    { \
        bool _nn_repair_result = (expression); \
        if ( !_nn_repair_result ) \
        { \
            SendMessage( "Abort! : %s (L%d)\n", \
                         NN_MACRO_STRINGIZE(expression), __LINE__); \
            do{ \
                nn::os::SleepThread(nn::TimeSpan::FromSeconds(1)); \
            }while(true);\
        } \
    } while ( NN_STATIC_CONDITION(false) )


