﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <glv.h>
#include <glv_binding.h>
#include <glv_resources.h>
#include <nv/nv_MemoryManagement.h>
#include <nvnTool/nvnTool_GlslcInterface.h>
#include <nn/repair/repair_StreamTextView.h>

namespace nn {
    namespace repair {

        bool StreamTextView::onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT
        {
            switch (e)
            {
            case glv::Event::MouseDrag:
            {
                const glv::Mouse& m = g.mouse();
                m_Index += static_cast<int>(-m.dy() / 4.8);

                auto Round = [](int value, int min, int max)
                {
                    value = value > max ? max : value;
                    value = value < min ? min : value;
                    return value;
                };

                m_Index = Round(m_Index, 0, static_cast<int>(m_StringArray.size()) - m_StringCountMax);

                this->Update();
            }
            break;
            default:
                break;
            }

            return true;
        }

        void StreamTextView::AppendValue(const std::string& text) NN_NOEXCEPT
        {
            std::string inputText = text;

            // 前の行に改行コードがない場合同一の string に収める
            if (m_StringArray.size() != 0)
            {
                if (m_StringArray.back().find("\n") == std::string::npos)
                {
                    inputText = m_StringArray.back() + inputText;
                    m_StringArray.pop_back();
                }
                else
                {
                    // 表示開始位置の更新
                    if (m_StringCountMax <= static_cast<int>(m_StringArray.size()))
                    {
                        m_Index++;
                    }
                }
            }

            m_StringArray.push_back(inputText);

            this->Update();
        }

        void StreamTextView::Clear() NN_NOEXCEPT
        {
            m_Index = 0;
            m_StringArray.clear();

            this->Update();
        }

        void StreamTextView::Update() NN_NOEXCEPT
        {
            // 表示行数
            int stringCountMax = std::min(m_StringCountMax, static_cast<int>(m_StringArray.size()));

            std::string outputStrings;
            for (int index = stringCountMax - 1 ; index >= 0; index--)
            {
                const auto& line = m_StringArray.at(index + m_Index);

                // 仕様上 512 文字以上の表示には制限がある
                if (outputStrings.size() + line.size() < 512)
                {
                    outputStrings.insert(0, m_StringArray.at(index + m_Index));
                }
            }

            this->setValue(outputStrings);
        }
    }
}
