﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/repair/repair_ShutdownButton.h>
#include "detail/repair_FirmwareVersion.h"
#include "detail/repair_SystemApplet.h"

namespace nn {
    namespace repair {

        const char* DispMsgShutdownEnable  = "Shutdown";
        const char* DispMsgShutdownDisable = "Hold PowerButton to shutdown";

        void MyMouseDownHandler() NN_NOEXCEPT
        {
            detail::FirmwareVersionNoCheck fw_version;
            detail::SystemApplet    system_applet;

            if( fw_version.IsAvailableShutdown() )
            {
                NN_SDK_LOG("shutdown requested\n");
                system_applet.RequestShutdown();
            }
            else
            {
                NN_SDK_LOG("shutdown is not implemented\n");
            }
        }

        ShutdownButton::ShutdownButton() NN_NOEXCEPT
          : LabelButton(MyMouseDownHandler)
          {
              detail::FirmwareVersionNoCheck fw_version;

              if( fw_version.IsAvailableShutdown() )
              {
                  m_label = new glv::Label(DispMsgShutdownEnable, false);
                  this->add(FitButton(m_label, 50, 4));
              }
              else
              {
                  m_label = new glv::Label(DispMsgShutdownDisable, false);

                  // 無効であることを示す為グレー表示
                  glv::Style* pStyle = new glv::Style();
                  pStyle->color.selection.set( 0.3f, 0.3f, 0.3f );
                  pStyle->color.text.set(0.5, 0.5, 0.5);
                  pStyle->color.fore.set(0.3, 0.3, 0.3);
                  pStyle->color.back.set(0.2, 0.2, 0.2);

                  m_label->style(pStyle);
                  this->style(pStyle);
                  this->add(FitButton(m_label, 30, 14));
              }
              this->pos(800,640); // デフォルトの位置
          }
    }
}
