﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/g3d_EditServer.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include <nw/g3d/edit/g3d_IAllocator.h>
#include "g3d_PingMonitor.h"
#include "g3d_CommandMonitor.h"

namespace nw { namespace g3d { namespace edit {

namespace detail {
class EditManager;
class EditCommandExecutor;
class EditRenderInfo;
class EditPickup;
class EditAnimControl;
}

class EditServer::Impl
{
public:
    Impl()
        : m_pEditManager(NULL)
        , m_CommandMonitor(&nw::g3d::edit::EditServer::Impl::AnalyzeCommand, &nw::g3d::edit::EditServer::Impl::ProcessCommand)
        , m_pEditRenderInfo(NULL)
        , m_pEditPickup(NULL)
        , m_pEditAnimControl(NULL)
        , m_pEditCommandExecutor(NULL)
        , m_pAllocator(NULL)
        , m_pCallback(NULL)
        , m_FileBuffer(NULL)
        , m_FileBufferSize(0)
    {
    }
    ~Impl();

    bool Initialize(const CreateArg& arg);

    bool IsConnected() const
    {
        return m_CommandMonitor.IsConnected();
    }

    void* GetFileBuffer()
    {
        return m_FileBuffer;
    }

    void** GetFileBufferRef()
    {
        return &m_FileBuffer;
    }

    int GetFileBufferSize() const
    {
        return m_FileBufferSize;
    }

    void ClearFileBuffer()
    {
        if (m_FileBuffer != NULL)
        {
            m_pAllocator->Free(m_FileBuffer);
            m_FileBuffer = NULL;
            m_FileBufferSize = 0;
        }
    }

    nw::g3d::edit::detail::EditManager* GetEditManager()
    {
        return m_pEditManager;
    }

    nw::g3d::edit::detail::PingMonitor* GetPingMonitor()
    {
        return &m_PingMonitor;
    }

    nw::g3d::edit::detail::CommandMonitor* GetCommandMonitor()
    {
        return &m_CommandMonitor;
    }

    bool IsFreezing() const
    {
        return m_PingMonitor.IsFreezing();
    }

    void PollDataCommunication();
    void PollDataEdit();

    nw::g3d::edit::detail::EditRenderInfo* GetEditRenderInfo()
    {
        return m_pEditRenderInfo;
    }

    nw::g3d::edit::detail::EditPickup* GetEditPickup()
    {
        return m_pEditPickup;
    }

    nw::g3d::edit::detail::EditAnimControl* GetEditAnimControl()
    {
        return m_pEditAnimControl;
    }

    void ClearState();

private:
    static bool AnalyzeCommand(nw::g3d::edit::detail::CommandMonitor::AnalyzeCommandArg& arg)
    {
        return s_Instance.m_pImpl->AnalyzeCommandImpl(arg);
    }

    static bool ProcessCommand(nw::g3d::edit::detail::CommandMonitor::ProcessCommandArg& arg)
    {
        return s_Instance.m_pImpl->ProcessCommandImpl(arg);
    }

    // @brief コマンド解析をして通信スレッド、メインスレッドで排他に扱う必要ない処理はここで実行します。
    bool AnalyzeCommandImpl(nw::g3d::edit::detail::CommandMonitor::AnalyzeCommandArg& arg);

    // @brief 通信スレッド、メインスレッドで排他で扱う必要がある処理を実行します。
    bool ProcessCommandImpl(nw::g3d::edit::detail::CommandMonitor::ProcessCommandArg& arg);

    // ファイルロード周りの処理は諸々EditCommandExecutorに処理を移したいが、
    // 通信処理で使っているファイルバッファ周りの取り回しが面倒なので保留
    void ExecuteFileLoadCommand(nw::g3d::edit::detail::CommandMonitor::ProcessCommandArg& processCommandArg);
    void ExecuteMultiFileLoadCommand(nw::g3d::edit::detail::CommandMonitor::ProcessCommandArg& processCommandArg);
    nw::g3d::res::ResShaderArchive* LoadResShaderArchive(const LoadFileArg& arg) const;
    void SwapShaderArchiveAlignSizeFromFileBuffer(u32* outAlignSize) const;
    void ExecuteLoadFile(const LoadFileArg& arg, const detail::FileDataBlock* block);
    void ExecuteReloadFile(const detail::FileDataBlock* block);
    void ExecuteResFileLoadCommand(detail::CommandFlag command, const detail::FileDataBlock* block, void* pFileBuffer, size_t fileBufferSize);
    void ExecuteShaderLoadCommand(detail::CommandFlag command, const detail::FileDataBlock* block, void* pFileBuffer, size_t fileBufferSize);

    // マテリアルアニメコマンドを適切な種類に変換する
    void ConvertMateriaAnimFileDataBlock(detail::FileDataBlock* block);

    const char* GetLogIndent() const
    {
        if (m_PingMonitor.IsFreezing())
        {
            return "    ";
        }
        else
        {
            return "";
        }
    }

private:
    nw::g3d::edit::detail::EditManager* m_pEditManager;
    nw::g3d::edit::detail::PingMonitor m_PingMonitor;
    nw::g3d::edit::detail::CommandMonitor m_CommandMonitor;

    nw::g3d::edit::detail::EditRenderInfo* m_pEditRenderInfo;
    nw::g3d::edit::detail::EditPickup* m_pEditPickup;
    nw::g3d::edit::detail::EditAnimControl* m_pEditAnimControl;
    nw::g3d::edit::detail::EditCommandExecutor* m_pEditCommandExecutor;

    volatile bool m_IsFileLoading;
    nw::g3d::edit::detail::HostFileDevice m_FileDevice;

    // 複数ファイル処理用状態の列挙型
    enum MultiFileState
    {
        MULTI_FILE_START = 0,   // 処理始め
        MULTI_FILE_INIT,        // 初期化処理
        MULTI_FILE_LOOPING,     // 複数ファイルループ処理中
        MULTI_FILE_LOADING,     // ファイルロード中
        MULTI_FILE_LOADED_ALL,  // 全ての複数ファイルロード終了
        MULTI_FILE_END,         // 処理終了
    };
    volatile MultiFileState m_MultiFileState;

    nw::g3d::edit::IAllocator* m_pAllocator;
    nw::g3d::edit::EditCallback* m_pCallback;

    void* m_FileBuffer;
    int m_FileBufferSize;

#if NW_G3D_IS_HOST_CAFE
    FSClient*               m_HostFileIOHandle;
#endif
};

}}} // namespace nw::g3d::edit

#endif // NW_G3D_CONFIG_USE_HOSTIO
