﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

namespace nw { namespace g3d {

class ModelObj;
class SkeletonObj;

namespace res {

class ResBone;

} // namespace res

namespace edit {

class IAllocator;

namespace detail {

class EditSkeletonObj;

/**
    @briefprivate 編集対象ボーンクラスです。
 */
class EditBone
{
    friend class EditSkeletonObj;
public:
    void Setup();
    void Cleanup();

    void SetBillboardFlag(bit32 flag);
    void SetVisibilityFlag(bool enable);

private:
    explicit EditBone(
        int index,
        nw::g3d::SkeletonObj* ownerSkeletonObj,
        nw::g3d::res::ResBone* resBone)
        : m_Index(index)
        , m_pOwnerSkeleton(ownerSkeletonObj)
        , m_pBone(resBone)
        , m_Flag(0)
    {}

    int m_Index;
    nw::g3d::SkeletonObj* m_pOwnerSkeleton;
    nw::g3d::res::ResBone* m_pBone;

    bit32 m_Flag;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditBone);
};

}} // nw::g3d::edit::detail
}} // namespace nw::g3d

#endif // NW_G3D_CONFIG_USE_HOSTIO
