﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "ut/g3d_EditWorkBuffer.h"
#include <nw/g3d/res/g3d_ResAnimCurve.h>

namespace nw { namespace g3d {

namespace edit {

class IAllocator;

namespace detail {

class EditAnimCurve
{
public:
    void Setup();
    void Cleanup();
    void Edit(const nw::g3d::res::ResAnimCurveData* pResAnimCurveData, size_t curveDataSize);
    explicit EditAnimCurve(
        int index,
        IAllocator* allocator,
        nw::g3d::res::ResAnimCurve* pAnimCurve)
        : m_Index(index)
        , m_pAllocator(allocator)
        , m_pAnimCurve(pAnimCurve)
        , m_FrameArrayBuffer(allocator)
        , m_KeyArrayBuffer(allocator)
    {
        NW_G3D_ASSERT(index >= 0);
        NW_G3D_ASSERT_NOT_NULL(allocator);
        NW_G3D_ASSERT_NOT_NULL(pAnimCurve);
    }

private:
    int m_Index;
    IAllocator* m_pAllocator;
    nw::g3d::res::ResAnimCurve*         m_pAnimCurve;
    nw::g3d::res::ResAnimCurveData      m_OrgAnimCurveData;
    nw::g3d::res::ResAnimCurve*         m_OrgAnimCurve;
    ut::detail::EditWorkBuffer m_FrameArrayBuffer;
    ut::detail::EditWorkBuffer m_KeyArrayBuffer;
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
