﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditAnimControl.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include "g3d_EditSocket.h"
#include "g3d_EditUtility.h"

namespace nw { namespace g3d { namespace edit { namespace detail {

EditAnimControl::EditAnimControl()
{
    m_SendAnimFrameCtrlPacket.header.command = SYSTEM_PLAY_FRAME_CTRL_COMMAND_FLAG;
    m_SendAnimFrameCtrlPacket.header.magic = NW_G3D_EDIT_MAGIC;
    m_SendAnimFrameCtrlPacket.header.verWord = NW_G3D_EDIT_VERSION;
    m_SendAnimFrameCtrlPacket.header.dataSize = sizeof(FrameCtrlBlock);
}

bool
EditAnimControl::SendAnimControl(EditSocket* socket)
{
    NW_G3D_ASSERT_NOT_NULL(socket);
    m_SendAnimFrameCtrlPacket.header.dataSize = sizeof(FrameCtrlBlock);
    return socket->WriteSync(&m_SendAnimFrameCtrlPacket, sizeof(m_SendAnimFrameCtrlPacket));
}

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
