﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/ndd/detail/ndd_Cipher.h>

namespace nn { namespace ndd {


Cipher::Cipher()
{
    //[todo]
    uint64_t seed = 100;
    for(int i=0;i<KeySize;++i)
    {
        seed*=12345;
        seed+=54321;
        g_Key[i] = seed % 0xFF;
    }
}

void Cipher::Encrypt(void* pData, size_t size)
{
    //[todo]
    NN_ABORT_UNLESS(size <= KeySize);
    for(int i=0;i<size;++i)
    {
        static_cast<uint8_t*>(pData)[i] ^= g_Key[i];
    }
}

void Cipher::Decrypt(void* pData, size_t size)
{
    //[todo]
    NN_ABORT_UNLESS(size <= KeySize);
    for(int i=0;i<size;++i)
    {
        static_cast<uint8_t*>(pData)[i] ^= g_Key[i];
    }
}

}}
