﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.account
{
    [ExternalStruct(16, 8)]
    [Pre(@"static_cast<bool>(_)")]
    [CppRefPath("<nn/account/account_Types.h>")]
    public struct Uid
    {
    }
}

namespace nn.nd
{
    [Serializable]
    [AttributeUsage(AttributeTargets.Parameter, AllowMultiple = true)]
    public class NotNullAttribute : PreAttribute
    {
        public NotNullAttribute()
            : base("_.GetPointerUnsafe() != nullptr && _.GetSize() > 0")
        {
        }
    }

    [ExternalStruct(392, 8)]
    [CppRefPath("<nn/nd/nd_NeighborInfoForSystem.h>")]
    [LargeData(true)]
    public struct NeighborInfoForSystem
    {
    }
}

namespace nn.ndd
{
    [CppRefPath(@"<nn/ndd/ndd_Types.h>")]
    [ExternalStruct(1216, 2)]
    [LargeData(true)]
    public struct SendDataDescription
    {
    }
}

namespace nn.nd.service
{
    public partial interface IScannerForSystem : IServiceObject
    {
        [MethodId(0)]
        Result StartScan();

        [MethodId(1)]
        Result CancelScan();

        [MethodId(2)]
        Result GetSystemEvent(Out<NativeHandle> pOutHandle);

        [MethodId(3)]
        Result GetScanResult(Out<int32_t> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NeighborInfoForSystem> outInfo, account.Uid uid);
    }


    public partial interface IServiceBase : IServiceObject
    {
        // アプリ・システム共通で使用する API : MethodId(0) ~
    }

    public partial interface IServiceForApplication : IServiceBase
    {
        // アプリ向け API : MethodId(100) ~
        [MethodId(100)]
        Result SetApplicationData(account.Uid uid, [NotNull] InBuffer buffer);

        [MethodId(101)]
        Result ClearApplicationData(account.Uid uid);
    }

    public partial interface IServiceForSystem : IServiceBase
    {
        // システム向け API : MethodId(200) ~
        [MethodId(200)]
        Result SetSystemData(account.Uid uid, [NotNull] sf.InBuffer buffer);

        [MethodId(201)]
        Result ClearSystemData(account.Uid uid);

        [MethodId(202)]
        Result GetNeighborInfoUpdateEventForSystem(Out<NativeHandle> pOutHandle);

        [MethodId(203)]
        Result GetReceivableNeighborInfoCountForSystem(Out<int32_t> pOutCount, account.Uid uid);

        [MethodId(204)]
        Result ReceiveNeighborInfoForSystem(Out<int32_t> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NeighborInfoForSystem> outInfo, account.Uid uid);

        [MethodId(205)]
        Result SetSender(account.Uid uid);

        [MethodId(206)]
        Result GetSender(Out<bool> pOutSenderExists, Out<account.Uid> pOutSender);

        // TODO: TransferMemory 対応
        [MethodId(207)]
        Result CreateScannerForSystem(Out<IScannerForSystem> pOut);

        // デバッグ向け API : MethodId(300) ~
        [MethodId(300)]
        Result AddReceivedNeighborInfoForSystemForDebug([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<NeighborInfoForSystem> info);

        [MethodId(301)]
        Result GetSendDataForDebug(Out<ndd.SendDataDescription> pOut, account.Uid uid);

        [MethodId(302)]
        Result ClearReceiveCounterForDebug(account.Uid uid);
    }
}
