﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nn.manu
{
    public interface IManu : IServiceObject
    {
        [MethodId(0)]
        void InitializeForUfio(uint32_t portNumber);
        [MethodId(1)]
        Result GetFileSize(Out<uint64_t> pOutData, InArray<char_t> path);
        [MethodId(2)]
        Result ReadFromHost(nn.sf.OutBuffer pOutBuffer, uint64_t bufferSize, InArray<char_t> path, uint64_t offset, uint64_t readSize);
        [MethodId(3)]
        Result WriteToHost(nn.sf.InBuffer pBuffer, uint64_t bufferSize, InArray<char_t> path, uint64_t offset, uint64_t writeSize);
        [MethodId(4)]
        void InitializeForUsbTransfer(uint32_t portNumber);
        [MethodId(5)]
        Result UsbRead(Out<uint64_t> pOutSuccessReadSize, nn.sf.OutBuffer pOutBuffer, uint64_t bufferSize, uint64_t readSize);
        [MethodId(6)]
        Result UsbWrite(Out<uint64_t> pOutSuccessWriteSize, nn.sf.InBuffer pBuffer, uint64_t bufferSize, uint64_t writeSize);
    }
}
