﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "manu_CreateUfioRequest.h"

#include <nn/manu/manu_IManu.sfdl.h> // for IManu
#include "manu_ServiceName.h" // for ManuUfioRequestServiceName
#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>

namespace nn { namespace manu {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateUfioRequestByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateUfioRequestByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<IManu> GetUfioRequestByHipc() NN_NOEXCEPT
{
    // ManuServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // IManu としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<IManu> ret;
    auto result = nn::sf::CreateHipcProxyByName<IManu, MyAllocator::Policy>(&ret, ManuServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

}}
