﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.ldn
{
    [CppRefPath(@"<nn/ldn/ldn_Ipv4Address.h>")]
    [ExternalStruct(4, 4)]
    public struct Ipv4Address { }

    [CppRefPath(@"<nn/ldn/ldn_Ipv4Address.h>")]
    [ExternalStruct(4, 4)]
    public struct SubnetMask { }

    [CppRefPath(@"<nn/ldn/ldn_MacAddress.h>")]
    [ExternalStruct(6, 1)]
    public struct MacAddress { }

    [CppRefPath(@"<nn/ldn/ldn_Types.h>")]
    [ExternalStruct(32, 8)]
    public struct NetworkConfig { }

    [CppRefPath(@"<nn/ldn/ldn_Types.h>")]
    [ExternalStruct(48, 4)]
    public struct UserConfig { }

    [CppRefPath(@"<nn/ldn/ldn_Types.h>")]
    [ExternalStruct(68, 4)]
    public struct SecurityConfig { }

    [CppRefPath(@"<nn/ldn/ldn_Types.h>")]
    [ExternalStruct(96, 8)]
    public struct ScanFilter { }

    [CppRefPath(@"<nn/ldn/ldn_Types.h>")]
    [ExternalStruct(64, 4)]
    public struct NodeInfo { }

    [CppRefPath(@"<nn/ldn/ldn_Types.h>")]
    [LargeData(true)]
    [ExternalStruct(1152, 8)]
    public struct NetworkInfo { }

    [CppRefPath(@"<nn/ldn/ldn_PrivateTypes.h>")]
    [ExternalStruct(12, 4)]
    public struct AddressEntry { }

    [CppRefPath(@"<nn/ldn/ldn_PrivateTypes.h>")]
    [ExternalStruct(32, 4)]
    public struct SecurityParameter { }

    [CppRefPath(@"<nn/ldn/ldn_Types.h>")]
    [ExternalStruct(8, 4)]
    public struct NodeLatestUpdate { }
}

namespace nn.ldn.detail
{
    public interface IStateGetService : IServiceObject
    {
        [MethodId(0)]
        Result GetState(
            Out<Bit32> pOutState
        );

        [MethodId(1)]
        Result GetNetworkInfo(
            Out<NetworkInfo> pOutNetwork
        );

        [MethodId(2)]
        Result GetIpv4Address(
            Out<Ipv4Address> pOutAddress,
            Out<SubnetMask> pOutMask
        );

        [MethodId(3)]
        Result GetDisconnectReason(
            Out<int16_t> pOutReason
        );

        [MethodId(4)]
        Result GetSecurityParameter(
            Out<SecurityParameter> pOutSecurityParameter
        );

        [MethodId(5)]
        Result GetNetworkConfig(
            Out<NetworkConfig> pOutNetworkConfig
        );
    }

    public interface ILocalCommunicationService : IStateGetService
    {
        [MethodId(100)]
        Result GetStateChangeEvent(
            Out<NativeHandle> pOutReadableHandle
        );

        [MethodId(101)]
        Result GetNetworkInfoAndHistory(
            Out<NetworkInfo> pOutNetwork,
            OutArray<NodeLatestUpdate> outUpdates
        );

        [MethodId(102)]
        Result Scan(
            [AutoSelectBuffer] OutArray<NetworkInfo> pOutScanResultArray,
            Out<int16_t> pOutCount,
            ScanFilter filter,
            int16_t channel
        );

        [MethodId(103)]
        Result ScanPrivate(
            [AutoSelectBuffer] OutArray<NetworkInfo> pOutScanResultArray,
            Out<int16_t> pOutCount,
            ScanFilter filter,
            int16_t channel
        );

        [MethodId(104)]
        Result SetWirelessControllerRestriction(Bit32 restriction);

        [MethodId(200)]
        Result OpenAccessPoint();

        [MethodId(201)]
        Result CloseAccessPoint();

        [MethodId(202)]
        Result CreateNetwork(
            NetworkConfig network,
            SecurityConfig security,
            UserConfig user
        );

        [MethodId(203)]
        Result CreateNetworkPrivate(
            NetworkConfig network,
            SecurityConfig securityConfig,
            SecurityParameter securityParam,
            UserConfig user,
            InArray<AddressEntry> entries
        );

        [MethodId(204)]
        Result DestroyNetwork();

        [MethodId(205)]
        Result Reject(
            Ipv4Address address
        );

        [MethodId(206)]
        Result SetAdvertiseData(
            [AutoSelectBuffer] InBuffer data
        );

        [MethodId(207)]
        Result SetStationAcceptPolicy(
            Bit8 policy
        );

        [MethodId(208)]
        Result AddAcceptFilterEntry(
            MacAddress station
        );

        [MethodId(209)]
        Result ClearAcceptFilter();

        [MethodId(300)]
        Result OpenStation();

        [MethodId(301)]
        Result CloseStation();

        [MethodId(302)]
        Result Connect(
            NetworkInfo network,
            SecurityConfig security,
            UserConfig user,
            int version,
            Bit32 option
        );

        [MethodId(303)]
        Result ConnectPrivate(
            NetworkConfig network,
            SecurityConfig securityConfig,
            SecurityParameter securityParam,
            UserConfig user,
            int version,
            Bit32 option
        );

        [MethodId(304)]
        Result Disconnect();
    }

    public interface IUserLocalCommunicationService : ILocalCommunicationService
    {
        [MethodId(400)]
        Result Initialize([ProcessId] nn.Bit64 pid);

        [MethodId(401)]
        Result Finalize();
    }

    public interface ISystemLocalCommunicationService : ILocalCommunicationService
    {
        [MethodId(400)]
        Result Initialize([ProcessId] nn.Bit64 pid);

        [MethodId(401)]
        Result Finalize();

        [MethodId(402)]
        Result SetOperationMode(Bit32 mode);
    }

    public interface IMonitorService : IStateGetService
    {
        [MethodId(100)]
        Result Initialize();

        [MethodId(101)]
        Result Finalize();
    }

    public interface IUserServiceCreator : IServiceObject
    {
        [MethodId(0)]
        Result CreateUserLocalCommunicationService(
            Out<IUserLocalCommunicationService> pOutService
        );
    }

    public interface IMonitorServiceCreator : IServiceObject
    {
        [MethodId(0)]
        Result CreateMonitorService(
            Out<IMonitorService> pOutService
        );
    }

    public interface ISystemServiceCreator : IServiceObject
    {
        [MethodId(0)]
        Result CreateSystemLocalCommunicationService(
            Out<ISystemLocalCommunicationService> pOutService
        );
    }
}
