﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/ldn/ldn_Types.h>

namespace nn { namespace ldn { namespace detail { namespace
{
}}}} // namespace detail::<unnamed>

namespace nn { namespace ldn { namespace detail
{
    size_t ConvertToString(State state, char* buffer, size_t bufferSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(buffer != nullptr);
        NN_SDK_ASSERT(StringizedStateLengthMax < bufferSize);
        switch (state)
        {
        case State_None:
            std::strncpy(buffer, "None", bufferSize);
            break;
        case State_Initialized:
            std::strncpy(buffer, "Initialized", bufferSize);
            break;
        case State_AccessPoint:
            std::strncpy(buffer, "AccessPoint", bufferSize);
            break;
        case State_AccessPointCreated:
            std::strncpy(buffer, "AccessPointCreated", bufferSize);
            break;
        case State_Station:
            std::strncpy(buffer, "Station", bufferSize);
            break;
        case State_StationConnected:
            std::strncpy(buffer, "StationConnected", bufferSize);
            break;
        default:
            NN_UNEXPECTED_DEFAULT;
            break;
        }
        return std::strlen(buffer);
    }

    size_t ConvertToString(AcceptPolicy policy, char* buffer, size_t bufferSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(buffer != nullptr);
        NN_SDK_ASSERT(StringizedAcceptPolicyLengthMax < bufferSize);
        switch (policy)
        {
        case AcceptPolicy_AlwaysAccept:
            std::strncpy(buffer, "AlwaysAccept", bufferSize);
            break;
        case AcceptPolicy_AlwaysReject:
            std::strncpy(buffer, "AlwaysReject", bufferSize);
            break;
        case AcceptPolicy_BlackList:
            std::strncpy(buffer, "BlackList", bufferSize);
            break;
        case AcceptPolicy_WhiteList:
            std::strncpy(buffer, "WhiteList", bufferSize);
            break;
        default:
            NN_UNEXPECTED_DEFAULT;
            break;
        }
        return std::strlen(buffer);
    }

    size_t ConvertToString(DisconnectReason reason, char* buffer, size_t bufferSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(buffer != nullptr);
        NN_SDK_ASSERT(StringizedDisconnectReasonLengthMax < bufferSize);
        switch (reason)
        {
        case DisconnectReason_Unknown:
            std::strncpy(buffer, "Unknown", bufferSize);
            break;
        case DisconnectReason_None:
            std::strncpy(buffer, "None", bufferSize);
            break;
        case DisconnectReason_DisconnectedByUser:
            std::strncpy(buffer, "DisconnectedByUser", bufferSize);
            break;
        case DisconnectReason_DisconnectedBySystem:
            std::strncpy(buffer, "DisconnectedBySystem", bufferSize);
            break;
        case DisconnectReason_DestroyedByUser:
            std::strncpy(buffer, "DestroyedByUser", bufferSize);
            break;
        case DisconnectReason_DestroyedBySystem:
            std::strncpy(buffer, "DestroyedBySystem", bufferSize);
            break;
        case DisconnectReason_Rejected:
            std::strncpy(buffer, "Rejected", bufferSize);
            break;
        case DisconnectReason_SignalLost:
            std::strncpy(buffer, "SignalLost", bufferSize);
            break;
        default:
            NN_UNEXPECTED_DEFAULT;
            break;
        }
        return std::strlen(buffer);
    }

    size_t ConvertToString(SecurityMode mode, char* buffer, size_t bufferSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(buffer != nullptr);
        NN_SDK_ASSERT(StringizedSecurityModeLengthMax < bufferSize);
        switch (mode)
        {
        case SecurityMode_Any:
            std::strncpy(buffer, "Any", bufferSize);
            break;
        case SecurityMode_Product:
            std::strncpy(buffer, "Product", bufferSize);
            break;
        case SecurityMode_Debug:
            std::strncpy(buffer, "Debug", bufferSize);
            break;
        case SecurityMode_SystemDebug:
            std::strncpy(buffer, "SystemDebug", bufferSize);
            break;
        default:
            NN_UNEXPECTED_DEFAULT;
            break;
        }
        return std::strlen(buffer);
    }

}}} // namespace nn::ldn
