﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_Random.h>

namespace nn { namespace ldn { namespace detail
{
    void FillSecureRandom(void* out, size_t bufferSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(out);
        NN_SDK_ASSERT(0 < bufferSize);
        nn::os::GenerateRandomBytes(out, bufferSize);
    }

}}} // namespace nn::ldn::detail
